/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class FilePathUtil {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FILE_PATH_SEPARATORS = File.separatorChar != '/' ? "/" + File.separator : File.separator;

    private FilePathUtil() {
    }

    public static String[] getPathSegments(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, FILE_PATH_SEPARATORS);
        ArrayList<String> segments = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            segments.add(tokenizer.nextToken());
        }
        return segments.toArray(EMPTY_STRING_ARRAY);
    }

    public static int sizeOfCommonPrefix(String path1, String path2, int offset) {
        return FilePathUtil.sizeOfCommonPrefix(path1, path2, offset, File.separatorChar);
    }

    public static int sizeOfCommonPrefix(String path1, String path2, int offset, char separatorChar) {
        int pos;
        int lastSeparator = 0;
        int maxPos = Math.min(path1.length(), path2.length() - offset);
        for (pos = 0; pos < maxPos && path1.charAt(pos) == path2.charAt(pos + offset); ++pos) {
            if (path1.charAt(pos) != separatorChar) continue;
            lastSeparator = pos;
        }
        if (pos == maxPos) {
            if (path1.length() == path2.length() - offset) {
                return pos;
            }
            if (pos < path1.length() && path1.charAt(pos) == separatorChar) {
                return pos;
            }
            if (pos < path2.length() - offset && path2.charAt(pos + offset) == separatorChar) {
                return pos;
            }
        }
        return lastSeparator;
    }

    public static String maybeRemoveTrailingSegments(String path, String pathToRemove) {
        Object[] lastSegments;
        Object[] removalSegments = FilePathUtil.getPathSegments(pathToRemove);
        String[] pathSegments = FilePathUtil.getPathSegments(path);
        int potentialRemovalIndex = pathSegments.length - removalSegments.length;
        if (potentialRemovalIndex > 0 && Arrays.equals(lastSegments = (String[])Arrays.stream(pathSegments).skip(potentialRemovalIndex).toArray(String[]::new), removalSegments)) {
            String maybeLeadingSeparator = FILE_PATH_SEPARATORS.contains(path.substring(0, 1)) ? "/" : "";
            return maybeLeadingSeparator + String.join((CharSequence)"/", Arrays.copyOf(pathSegments, potentialRemovalIndex));
        }
        return path;
    }
}

