/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.border.EmptyBorder;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.helper.swing.NbiDialog;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiPanel;
import org.netbeans.installer.utils.helper.swing.NbiScrollPane;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;

public class InstallationLogDialog
extends NbiDialog {
    private NbiTextPane logPane;
    private NbiPanel logPanel;
    private NbiScrollPane logScrollPane;
    private NbiLabel errorLabel;
    private File logFile;
    private static final String MSG_LOADING_LOGFILE_KEY = "ILD.loading.logfile";
    private static final String ERROR_READING_LOGFILE_KEY = "ILD.error.reading.log";
    private static final String ERROR_LOG_CONTENTS = "ILD.error.log.contents";

    public InstallationLogDialog() {
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        this.logFile = LogManager.getLogFile();
        this.setTitle(this.logFile.getAbsolutePath());
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.logPane = new NbiTextPane();
        this.logPane.setFont(new Font("Monospaced", this.logPane.getFont().getStyle(), this.logPane.getFont().getSize()));
        this.logPanel = new NbiPanel();
        this.logPanel.setLayout(new BorderLayout());
        this.logPanel.add((Component)this.logPane, "Center");
        this.logScrollPane = new NbiScrollPane(this.logPanel);
        this.logScrollPane.setViewportBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.logScrollPane.setHorizontalScrollBarPolicy(32);
        this.errorLabel = new NbiLabel();
        this.add((Component)this.logScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 11, 11, 11), 0, 0));
        this.add((Component)this.errorLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(11, 11, 11, 11), 0, 0));
    }

    public void loadLogFile() {
        try {
            this.logScrollPane.setVisible(false);
            this.errorLabel.setVisible(true);
            this.errorLabel.setText(ResourceUtils.getString(InstallationLogDialog.class, MSG_LOADING_LOGFILE_KEY));
            this.logPane.setText(FileUtils.readFile(this.logFile));
            this.logPane.setCaretPosition(0);
            this.logScrollPane.setVisible(true);
            this.errorLabel.setVisible(false);
        }
        catch (IOException e) {
            ErrorManager.notify(2, ResourceUtils.getString(InstallationLogDialog.class, ERROR_READING_LOGFILE_KEY, this.logFile), e);
            this.errorLabel.setText(ResourceUtils.getString(InstallationLogDialog.class, ERROR_LOG_CONTENTS));
            this.logScrollPane.setVisible(false);
            this.errorLabel.setVisible(true);
        }
    }
}

