/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.util.Collections;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AnnotatedElementContext;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.io.CleanupMode;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.io.TempDirFactory;
import org.junit.jupiter.engine.config.EnumConfigurationParameterConverter;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;

class TempDirectory
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TempDirectory.class});
    private static final String KEY = "temp.dir";
    private static final String FAILURE_TRACKER = "failure.tracker";
    private static final String CHILD_FAILED = "child.failed";
    static final String FILE_OPERATIONS_KEY = "file.operations";
    private final JupiterConfiguration configuration;

    public TempDirectory(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    public void beforeAll(ExtensionContext context) {
        TempDirectory.installFailureTracker(context);
        this.injectStaticFields(context, context.getRequiredTestClass());
    }

    public void beforeEach(ExtensionContext context) {
        TempDirectory.installFailureTracker(context);
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectInstanceFields(context, instance));
    }

    private static void installFailureTracker(ExtensionContext context) {
        context.getStore(NAMESPACE).put((Object)FAILURE_TRACKER, () -> context.getParent().ifPresent(it -> {
            if (TempDirectory.selfOrChildFailed(context)) {
                it.getStore(NAMESPACE).put((Object)CHILD_FAILED, (Object)true);
            }
        }));
    }

    private void injectStaticFields(ExtensionContext context, Class<?> testClass) {
        this.injectFields(context, null, testClass, ReflectionUtils::isStatic);
    }

    private void injectInstanceFields(ExtensionContext context, Object instance) {
        this.injectFields(context, instance, instance.getClass(), ReflectionUtils::isNotStatic);
    }

    private void injectFields(ExtensionContext context, Object testInstance, Class<?> testClass, Predicate<Field> predicate) {
        Scope scope = this.getScope(context);
        AnnotationUtils.findAnnotatedFields(testClass, TempDir.class, predicate).forEach(field -> {
            this.assertNonFinalField((Field)field);
            this.assertSupportedType("field", field.getType());
            try {
                CleanupMode cleanupMode = this.determineCleanupModeForField((Field)field);
                TempDirFactory factory = this.determineTempDirFactoryForField((Field)field, scope);
                ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(testInstance, this.getPathOrFile(new FieldContext((Field)field), field.getType(), factory, cleanupMode, scope, context));
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean annotated = parameterContext.isAnnotated(TempDir.class);
        if (annotated && parameterContext.getDeclaringExecutable() instanceof Constructor) {
            throw new ParameterResolutionException("@TempDir is not supported on constructor parameters. Please use field injection instead.");
        }
        return annotated;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        this.assertSupportedType("parameter", parameterType);
        CleanupMode cleanupMode = this.determineCleanupModeForParameter(parameterContext);
        Scope scope = this.getScope(extensionContext);
        TempDirFactory factory = this.determineTempDirFactoryForParameter(parameterContext, scope);
        return this.getPathOrFile((AnnotatedElementContext)parameterContext, parameterType, factory, cleanupMode, scope, extensionContext);
    }

    private CleanupMode determineCleanupModeForField(Field field) {
        TempDir tempDir = (TempDir)AnnotationUtils.findAnnotation((AnnotatedElement)field, TempDir.class).orElseThrow(() -> new JUnitException("Field " + field + " must be annotated with @TempDir"));
        return this.determineCleanupMode(tempDir);
    }

    private CleanupMode determineCleanupModeForParameter(ParameterContext parameterContext) {
        TempDir tempDir = (TempDir)parameterContext.findAnnotation(TempDir.class).orElseThrow(() -> new JUnitException("Parameter " + parameterContext.getParameter() + " must be annotated with @TempDir"));
        return this.determineCleanupMode(tempDir);
    }

    private CleanupMode determineCleanupMode(TempDir tempDir) {
        CleanupMode cleanupMode = tempDir.cleanup();
        return cleanupMode == CleanupMode.DEFAULT ? this.configuration.getDefaultTempDirCleanupMode() : cleanupMode;
    }

    private Scope getScope(ExtensionContext context) {
        return (Scope)((Object)context.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent(Scope.class, __ -> new EnumConfigurationParameterConverter<Scope>(Scope.class, "@TempDir scope").get("junit.jupiter.tempdir.scope", arg_0 -> ((ExtensionContext)context).getConfigurationParameter(arg_0), Scope.PER_DECLARATION), Scope.class));
    }

    private TempDirFactory determineTempDirFactoryForField(Field field, Scope scope) {
        TempDir tempDir = (TempDir)AnnotationUtils.findAnnotation((AnnotatedElement)field, TempDir.class).orElseThrow(() -> new JUnitException("Field " + field + " must be annotated with @TempDir"));
        return this.determineTempDirFactory(tempDir, scope);
    }

    private TempDirFactory determineTempDirFactoryForParameter(ParameterContext parameterContext, Scope scope) {
        TempDir tempDir = (TempDir)parameterContext.findAnnotation(TempDir.class).orElseThrow(() -> new JUnitException("Parameter " + parameterContext.getParameter() + " must be annotated with @TempDir"));
        return this.determineTempDirFactory(tempDir, scope);
    }

    private TempDirFactory determineTempDirFactory(TempDir tempDir, Scope scope) {
        Class factory = tempDir.factory();
        if (factory != TempDirFactory.class && scope == Scope.PER_CONTEXT) {
            throw new ExtensionConfigurationException("Custom @TempDir factory is not supported with junit.jupiter.tempdir.scope=" + Scope.PER_CONTEXT.name().toLowerCase() + ". Use " + "junit.jupiter.tempdir.factory.default" + " instead.");
        }
        return factory == TempDirFactory.class ? this.configuration.getDefaultTempDirFactorySupplier().get() : (TempDirFactory)ReflectionUtils.newInstance((Class)factory, (Object[])new Object[0]);
    }

    private void assertNonFinalField(Field field) {
        if (ReflectionUtils.isFinal((Member)field)) {
            throw new ExtensionConfigurationException("@TempDir field [" + field + "] must not be declared as final.");
        }
    }

    private void assertSupportedType(String target, Class<?> type) {
        if (type != Path.class && type != File.class) {
            throw new ExtensionConfigurationException("Can only resolve @TempDir " + target + " of type " + Path.class.getName() + " or " + File.class.getName() + " but was: " + type.getName());
        }
    }

    private Object getPathOrFile(AnnotatedElementContext elementContext, Class<?> type, TempDirFactory factory, CleanupMode cleanupMode, Scope scope, ExtensionContext extensionContext) {
        ExtensionContext.Namespace namespace = scope == Scope.PER_DECLARATION ? NAMESPACE.append(new Object[]{elementContext}) : NAMESPACE;
        Path path = ((CloseablePath)extensionContext.getStore(namespace).getOrComputeIfAbsent((Object)KEY, __ -> TempDirectory.createTempDir(factory, cleanupMode, elementContext, extensionContext), CloseablePath.class)).get();
        return type == Path.class ? path : path.toFile();
    }

    static CloseablePath createTempDir(TempDirFactory factory, CleanupMode cleanupMode, AnnotatedElementContext elementContext, ExtensionContext extensionContext) {
        try {
            return new CloseablePath(factory, cleanupMode, elementContext, extensionContext);
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Failed to create default temp directory", (Throwable)ex);
        }
    }

    private static boolean selfOrChildFailed(ExtensionContext context) {
        return context.getExecutionException().isPresent() || (Boolean)context.getStore(NAMESPACE).getOrDefault((Object)CHILD_FAILED, Boolean.class, (Object)false) != false;
    }

    static enum Scope {
        PER_CONTEXT,
        PER_DECLARATION;

    }

    static class CloseablePath
    implements ExtensionContext.Store.CloseableResource {
        private static final Logger logger = LoggerFactory.getLogger(CloseablePath.class);
        private final Path dir;
        private final TempDirFactory factory;
        private final CleanupMode cleanupMode;
        private final ExtensionContext extensionContext;

        CloseablePath(TempDirFactory factory, CleanupMode cleanupMode, AnnotatedElementContext elementContext, ExtensionContext extensionContext) throws Exception {
            this.dir = factory.createTempDirectory(elementContext, extensionContext);
            this.factory = factory;
            this.cleanupMode = cleanupMode;
            this.extensionContext = extensionContext;
        }

        Path get() {
            return this.dir;
        }

        public void close() throws IOException {
            try {
                if (this.cleanupMode == CleanupMode.NEVER || this.cleanupMode == CleanupMode.ON_SUCCESS && TempDirectory.selfOrChildFailed(this.extensionContext)) {
                    logger.info(() -> "Skipping cleanup of temp dir " + this.dir + " due to cleanup mode configuration.");
                    return;
                }
                FileOperations fileOperations = (FileOperations)this.extensionContext.getStore(NAMESPACE).getOrDefault((Object)TempDirectory.FILE_OPERATIONS_KEY, FileOperations.class, (Object)FileOperations.DEFAULT);
                SortedMap<Path, IOException> failures = this.deleteAllFilesAndDirectories(fileOperations);
                if (!failures.isEmpty()) {
                    throw this.createIOExceptionWithAttachedFailures(failures);
                }
            }
            finally {
                this.factory.close();
            }
        }

        private SortedMap<Path, IOException> deleteAllFilesAndDirectories(final FileOperations fileOperations) throws IOException {
            if (Files.notExists(this.dir, new LinkOption[0])) {
                return Collections.emptySortedMap();
            }
            final TreeMap<Path, IOException> failures = new TreeMap<Path, IOException>();
            final HashSet retriedPaths = new HashSet();
            CloseablePath.tryToResetPermissions(this.dir);
            Files.walkFileTree(this.dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (!dir.equals(dir)) {
                        CloseablePath.tryToResetPermissions(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    this.resetPermissionsAndTryToDeleteAgain(file, exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    return this.deleteAndContinue(file);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return this.deleteAndContinue(dir);
                }

                private FileVisitResult deleteAndContinue(Path path) {
                    try {
                        fileOperations.delete(path);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                    }
                    catch (DirectoryNotEmptyException exception) {
                        failures.put(path, exception);
                    }
                    catch (IOException exception) {
                        this.resetPermissionsAndTryToDeleteAgain(path, exception);
                    }
                    return FileVisitResult.CONTINUE;
                }

                private void resetPermissionsAndTryToDeleteAgain(Path path, IOException exception) {
                    block5: {
                        boolean notYetRetried = retriedPaths.add(path);
                        if (notYetRetried) {
                            try {
                                CloseablePath.tryToResetPermissions(path);
                                if (Files.isDirectory(path, new LinkOption[0])) {
                                    Files.walkFileTree(path, this);
                                    break block5;
                                }
                                fileOperations.delete(path);
                            }
                            catch (Exception suppressed) {
                                exception.addSuppressed(suppressed);
                                failures.put(path, exception);
                            }
                        } else {
                            failures.put(path, exception);
                        }
                    }
                }
            });
            return failures;
        }

        private static void tryToResetPermissions(Path path) {
            DosFileAttributeView dos;
            File file;
            try {
                file = path.toFile();
            }
            catch (UnsupportedOperationException ignore) {
                return;
            }
            file.setReadable(true);
            file.setWritable(true);
            if (Files.isDirectory(path, new LinkOption[0])) {
                file.setExecutable(true);
            }
            if ((dos = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0])) != null) {
                try {
                    dos.setReadOnly(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private IOException createIOExceptionWithAttachedFailures(SortedMap<Path, IOException> failures) {
            Path emptyPath = Paths.get("", new String[0]);
            String joinedPaths = failures.keySet().stream().map(this::tryToDeleteOnExit).map(this::relativizeSafely).map(path -> emptyPath.equals(path) ? "<root>" : path.toString()).collect(Collectors.joining(", "));
            IOException exception = new IOException("Failed to delete temp directory " + this.dir.toAbsolutePath() + ". The following paths could not be deleted (see suppressed exceptions for details): " + joinedPaths);
            failures.values().forEach(exception::addSuppressed);
            return exception;
        }

        private Path tryToDeleteOnExit(Path path) {
            try {
                path.toFile().deleteOnExit();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return path;
        }

        private Path relativizeSafely(Path path) {
            try {
                return this.dir.relativize(path);
            }
            catch (IllegalArgumentException e) {
                return path;
            }
        }
    }

    private static class FieldContext
    implements AnnotatedElementContext {
        private final Field field;

        private FieldContext(Field field) {
            this.field = (Field)Preconditions.notNull((Object)field, (String)"field must not be null");
        }

        public AnnotatedElement getAnnotatedElement() {
            return this.field;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("field", (Object)this.field).toString();
        }
    }

    static interface FileOperations {
        public static final FileOperations DEFAULT = Files::delete;

        public void delete(Path var1) throws IOException;
    }
}

