/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.nio.ByteBuffer;
import java.util.Arrays;
import jlibs.core.io.BOM;
import jlibs.core.io.IOUtil;

public interface EncodingDetector {
    public static final EncodingDetector DEFAULT = new EncodingDetector(){

        @Override
        public String detect(ByteBuffer buffer) {
            BOM bom = BOM.detect(buffer);
            return bom == null ? null : bom.encoding();
        }
    };
    public static final EncodingDetector XML = new EncodingDetector(){
        final int[] UTF32_LE = new int[]{60, 0, 0, 0};
        final int[] UTF32_BE = new int[]{0, 0, 0, 60};
        final int[] UTF_16LE = new int[]{60, 0, 63, 0};
        final int[] UTF_16BE = new int[]{0, 60, 0, 63};
        final int[] UTF_8 = new int[]{60, 63, 120, 109};
        final int[] CP037 = new int[]{76, 111, 167, 148};

        @Override
        public String detect(ByteBuffer buffer) {
            String encoding = DEFAULT.detect(buffer);
            if (encoding != null) {
                return encoding;
            }
            if (buffer.remaining() >= 4) {
                int[] values = new int[]{buffer.get() & 0xFF, buffer.get() & 0xFF, buffer.get() & 0xFF, buffer.get() & 0xFF};
                buffer.position(buffer.position() - 4);
                if (Arrays.equals(this.UTF32_LE, values)) {
                    return IOUtil.UTF_32LE.name();
                }
                if (Arrays.equals(this.UTF32_BE, values)) {
                    return IOUtil.UTF_32BE.name();
                }
                if (Arrays.equals(this.UTF_16LE, values)) {
                    return IOUtil.UTF_16LE.name();
                }
                if (Arrays.equals(this.UTF_16BE, values)) {
                    return IOUtil.UTF_16BE.name();
                }
                if (Arrays.equals(this.UTF_8, values)) {
                    return IOUtil.UTF_8.name();
                }
                if (Arrays.equals(this.CP037, values)) {
                    return "Cp037";
                }
            }
            return IOUtil.UTF_8.name();
        }
    };
    public static final EncodingDetector JSON = new EncodingDetector(){

        @Override
        public String detect(ByteBuffer buffer) {
            String encoding = DEFAULT.detect(buffer);
            if (encoding != null) {
                return encoding;
            }
            if (buffer.remaining() >= 4) {
                int flag = 0;
                for (int i = 0; i < 4; ++i) {
                    if (buffer.get() == 0) continue;
                    flag |= 1 << i;
                }
                buffer.position(buffer.position() - 4);
                switch (flag) {
                    case 1: {
                        return IOUtil.UTF_32LE.name();
                    }
                    case 5: {
                        return IOUtil.UTF_16LE.name();
                    }
                    case 8: {
                        return IOUtil.UTF_32BE.name();
                    }
                    case 10: {
                        return IOUtil.UTF_16BE.name();
                    }
                }
            }
            return IOUtil.UTF_8.name();
        }
    };

    public String detect(ByteBuffer var1);
}

