/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.rundeck.client.api.model.scheduler.ScheduledJobItem;
import org.rundeck.client.api.model.scheduler.SchedulerTakeover;
import org.rundeck.client.api.model.scheduler.SchedulerTakeoverResult;
import org.rundeck.client.api.model.scheduler.TakeoverJobItem;
import org.rundeck.client.api.model.scheduler.TakeoverServerItem;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.VerboseOption;
import picocli.CommandLine;

@CommandLine.Command(description={"View scheduler information"}, name="scheduler")
public class Scheduler
extends BaseCommand {
    @CommandLine.Command(description={"List jobs for the current target server, or a specified server."})
    public void jobs(@CommandLine.Mixin SchedulerJobs options) throws IOException, InputError {
        List jobInfo = (List)this.apiCall(api -> {
            if (options.isUuid()) {
                return api.listSchedulerJobs(options.getUuid());
            }
            return api.listSchedulerJobs();
        });
        this.getRdOutput().output(jobInfo.stream().map(ScheduledJobItem::toMap).collect(Collectors.toList()));
    }

    @CommandLine.Command(description={"Tell a Rundeck server in cluster mode to claim all scheduled jobs from another cluster server. Use --job/-j to specify a job uuid, or alternatively use --uuid/-u, --all/-a, --project/-p to specify a server/project combination."})
    public void takeover(@CommandLine.Mixin Takeover options) throws IOException, InputError {
        SchedulerTakeover takeoverParams = new SchedulerTakeover();
        if (options.isJobId()) {
            takeoverParams.setJob(new SchedulerTakeover.JobId().setId(options.getJobId()));
        } else {
            if (options.isAllServers()) {
                takeoverParams.setServer(new TakeoverServerItem().setAll(true));
            } else if (options.isUuid()) {
                takeoverParams.setServer(new TakeoverServerItem().setUuid(options.getUuid()));
            } else {
                throw new InputError("Must specify -u, or -a or -j to specify jobs to takeover.");
            }
            if (options.isProjectName()) {
                takeoverParams.setProject(options.getProjectName());
            }
        }
        SchedulerTakeoverResult response = (SchedulerTakeoverResult)this.apiCall(api -> api.takeoverSchedule(takeoverParams));
        this.getRdOutput().info(response.getMessage());
        if (response.getTakeoverSchedule() != null && response.getTakeoverSchedule().getJobs() != null && response.getTakeoverSchedule().getJobs().getFailed() != null && response.getTakeoverSchedule().getJobs().getFailed().size() > 0) {
            this.getRdOutput().error(String.format("Failed to takeover %d Jobs%n", response.getTakeoverSchedule().getJobs().getFailed().size()));
            this.getRdOutput().output(response.getTakeoverSchedule().getJobs().getFailed().stream().map(TakeoverJobItem::toString).collect(Collectors.toList()));
        }
        if (options.isVerbose()) {
            if (response.getTakeoverSchedule() != null && response.getTakeoverSchedule().getJobs() != null && response.getTakeoverSchedule().getJobs().getSuccessful() != null && response.getTakeoverSchedule().getJobs().getSuccessful().size() > 0) {
                this.getRdOutput().info(String.format("Successfully taken over %d Jobs%n", response.getTakeoverSchedule().getJobs().getSuccessful().size()));
                this.getRdOutput().output(response.getTakeoverSchedule().getJobs().getSuccessful().stream().map(TakeoverJobItem::toString).collect(Collectors.toList()));
            } else {
                this.getRdOutput().warning("* No jobs were taken over.");
            }
        }
    }

    static class Takeover
    extends VerboseOption {
        @CommandLine.Option(names={"-u", "--uuid"}, description={"Server UUID to take over."})
        String uuid;
        @CommandLine.Option(names={"-a", "--all"}, description={"Take over all jobs regardless of server UUID."})
        boolean allServers;
        @CommandLine.Option(names={"-p", "--project"}, description={"Take over only jobs matching the given project name, in combination with --all/-a or --uuid/-u."})
        String projectName;
        @CommandLine.Option(names={"-j", "--job"}, description={"Job UUID to takeover only a single Job\u2019s schedule."})
        String jobId;

        Takeover() {
        }

        boolean isUuid() {
            return this.uuid != null;
        }

        boolean isProjectName() {
            return this.projectName != null;
        }

        boolean isJobId() {
            return this.jobId != null;
        }

        public String getUuid() {
            return this.uuid;
        }

        public boolean isAllServers() {
            return this.allServers;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public void setAllServers(boolean allServers) {
            this.allServers = allServers;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }
    }

    static class SchedulerJobs {
        @CommandLine.Option(names={"-u", "--uuid"}, description={"Server UUID to query, or blank to select the target server"})
        private String uuid;

        SchedulerJobs() {
        }

        boolean isUuid() {
            return this.uuid != null;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }
    }
}

