/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.ops4j.pax.exam.options.MavenUrlReference;

public class MavenUtils {
    private MavenUtils() {
    }

    public static String getArtifactVersion(String groupId, String artifactId) {
        Properties dependencies = new Properties();
        InputStream depInputStream = null;
        try {
            String depFilePath = "META-INF/maven/dependencies.properties";
            URL fileURL = MavenUtils.class.getClassLoader().getResource(depFilePath);
            if (fileURL == null) {
                fileURL = Thread.currentThread().getContextClassLoader().getResource(depFilePath);
            }
            if (fileURL == null) {
                throw new FileNotFoundException("File [" + depFilePath + "] could not be found in classpath");
            }
            depInputStream = fileURL.openStream();
            dependencies.load(depInputStream);
            String version = dependencies.getProperty(groupId + "/" + artifactId + "/version");
            if (version == null) {
                throw new IllegalArgumentException("Could not resolve version. Do you have a dependency for " + groupId + "/" + artifactId + " in your maven project?");
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not resolve version for groupId:" + groupId + " artifactId:" + artifactId + " by reading the dependency information generated by maven.", e);
        }
        finally {
            if (depInputStream != null) {
                try {
                    depInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static MavenUrlReference.VersionResolver asInProject() {
        return new MavenUrlReference.VersionResolver(){

            @Override
            public String getVersion(String groupId, String artifactId) {
                return MavenUtils.getArtifactVersion(groupId, artifactId);
            }
        };
    }
}

