#ifndef ___DMW96OSDM_H
#define ___DMW96OSDM_H

#include <video/dmw96osdm_common.h>
#include <linux/dmw96dma.h>
#include <linux/wait.h>
#include <linux/semaphore.h>
#include <linux/spinlock.h>


struct dmw96plane {

	struct fb_info info;
	unsigned int config;
	struct osdm_position pos;
	unsigned int enb;
	unsigned int commited;
	unsigned int just_committed;
	unsigned int chroma_enb;
	unsigned int per_pixel_alpha_enb;
	struct osdm_mask mask;
	unsigned char per_plane_alpha;
	osdm_rgb888 chroma_key;
	unsigned int byte_order[3];
	unsigned int cur_phy_addr;
	unsigned int offset;

	/*Transparency setting*/
	struct fb_var_screeninfo t_dim;
	struct osdm_position t_pos;
	osdm_abgr8888 t_pixel_color;

	/*Relevant to Video planes only*/
	struct osdm_video_color_control  video_color_control;
	struct osdm_video_limits video_limits;

	/*Relevant to OSD planes only*/
	unsigned short pal_red[OSDM_PALETTE_ARRAY_SIZE];
	unsigned short pal_green[OSDM_PALETTE_ARRAY_SIZE];
	unsigned short pal_blue[OSDM_PALETTE_ARRAY_SIZE];
	unsigned short pal_transp[OSDM_PALETTE_ARRAY_SIZE];
	unsigned int pal_size;
	unsigned int lut_base;
    
	/*Relevant to Display plane only*/
	osdm_rgb888 bg_color;
	unsigned int bg_enb;
	unsigned int dithering;
	unsigned int pause;
	unsigned int loop_mode;
	
	/*Memory setting*/
	void __iomem *vidmem;
#ifdef CONFIG_MACH_VERSATILE_BROADTILE
	unsigned long smem_start;
#endif
#ifndef CONFIG_MACH_VERSATILE_BROADTILE
	dma_addr_t dma_addr;
#endif

	unsigned int rotate_mem;
	/*We need 2 list because me use double buffers*/
	struct dmw96dma_list *list[2];
	/* 
	   dst/sec[0],dst/sec[1],dst/sec[2] are the destination/source of the first buffer
	 
	   where dst/sec[0] include the packed RGB/YUV or Y in case of SemiPlanar or Planar
	   where dst/sec[1] include the UV in case of SemiPlanar or U in case Planar
	   where dst/sec[2] include the V in case of Planar
	 
	   dst/sec[3],dst/sec[4],dst/sec[5] are the destination/source of the second buffer
	*/
	struct dmw96dma_image src[6];
	struct dmw96dma_image dst[6];
	struct semaphore rotate_sem;

	/*This semaphore is for mutual exlusion when 2 different process try to set same plane*/
	struct semaphore setting_sem;
	struct semaphore pan_sync_sem;
};

struct dmw96osdm {
	struct dmw96plane planes[NUM_OF_PLANES];
	
	struct dmw96plane uncommitted_planes[NUM_OF_PLANES];

	spinlock_t *copy_lock;

	volatile unsigned int is_working;
    int irq;
	struct clk *clk;
};

#define FB2OOSDM(fb_info) ((struct dmw96osdm *)(fb_info->par))


int create_osdm_sysfs(struct fb_info *fbi);

void remove_osdm_sysfs(struct fb_info *fbi);

#endif /* ___DMW96OSDM_H */
