/*
 * dmw-tdm.h -- DMW ASoC CPU DAI driver
 *
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * 16 October, 2011: 
 * Adapted to kernel 2.6.39 by Avi Miller <Avi.Miller@dspg.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __DMW_TDM_H
#define __DMW_TDM_H

#include <sound/soc.h>

extern int dmw_tdm_set_bits_per_sample(struct snd_soc_dai *cpu_dai, unsigned int bps);

extern void dmw_tdm_set_telephony(const char *cpu_dai_name, int tel_rqst);

typedef void (*tdm_reset_fp_t)(int enable);

/* Platform data structure */
struct dmw_tdm_pdata {
	tdm_reset_fp_t reset;
};

#endif

