/*
 * include/media/ov2643.h
 *
 * Shared settings for the OV2643 CameraChip.
 *
 * Copyright (C) 2011 DSPG.
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */

#ifndef OV2643_H
#define OV2643_H

#include <linux/videodev2.h>

#define OV2643_I2C_ADDR                0x30

#include <mach/camera.h>

struct ov2643_sensor_platform_data {
	int output_drive_capability;
};

struct ov2643_platform_data {
       /* Set power state, zero is off, non-zero is on. */
       int (*power_set)(enum v4l2_power power);
       u32 (*set_xclk)(unsigned long xclkfreq);
       int (*priv_data_set)(void *);
};

#endif /* ifndef OV2643_H */
