/*
 *  arch/arm/mach-dmw/css/cmsg-datahandler.h - datahandler cmsg layer
 *
 *  Copyright (C) 2007 NXP Semiconductors
 *  Copyright (C) 2008 - 2011 DSP Group Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* == HISTORY =================================================================
 *
 * Name         Date        Ver   Action
 * --------------------------------------------------------------------
 *  tcmc_awe    28-Jan-2010       initial 
 *  rhulagur    23-Feb-2010  1    Merging to 823
 *  tcmc_awe    16-Jun-2010       GPL header
 */

#ifndef CMSG_DATAHANDLER_H
#define CMSG_DATAHANDLER_H

#include "cmsg.h"

enum cmsg_datahandler_types {
	CMSG_DATAHANDLER_REQUEST_INIT = 0,
	CMSG_DATAHANDLER_REPLY_INIT,
	CMSG_DATAHANDLER_REQUEST_EST_DATA_CALL,
	CMSG_DATAHANDLER_REPLY_EST_DATA_CALL,
	CMSG_DATAHANDLER_HS_EST_DATA_CALL, // HS established the data call link
	CMSG_DATAHANDLER_REQUEST_DISC_DATA_CALL,
	CMSG_DATAHANDLER_REPLY_DISC_DATA_CALL,
	CMSG_DATAHANDLER_HS_DISC_DATA_CALL,	// HS disconnected the data call link
	CMSG_DATAHANDLER_REPLY_READ,
	CMSG_DATAHANDLER_REQUEST_WRITE,
	CMSG_DATAHANDLER_REPLY_WRITE,
};

union cmsg_datahandler_params {
	/* CMSG_DATAHANDLER_REPLY_INIT */
	struct reply_data_init {
		int result;
	} reply_init;

	/* CMSG_DATAHANDLER_REQUEST_EST_DATA_CALL */
	struct request_est_data_call {
		int handset;
		unsigned char bearertype;
	} request_est_data_call;

	/* CMSG_DATAHANDLER_REPLY_EST_DATA_CALL */
	struct reply_est_data_call {
		int handset;
		int result;
	} reply_est_data_call;

	/* CMSG_DATAHANDLER_REQUEST_DISC_DATA_CALL */
	struct request_disc_data_call {
		int handset;
	} request_disc_data_call;

	/* CMSG_DATAHANDLER_REPLY_DISC_DATA_CALL */
	struct reply_disc_data_call {
		int handset;
		int result;
	} reply_disc_data_call;

	/* CMSG_DATAHANDLER_REPLY_READ */
	struct reply_read {
		int handset;
		int result;
	} reply_read;

	/* CMSG_DATAHANDLER_REQUEST_WRITE */
	struct request_write {
		int handset;
	} request_write;

	/* CMSG_DATAHANDLER_REPLY_WRITE */
	struct reply_write {
		int handset;
		int result;
	} reply_write;
};



#endif /* CMSG_DATAHANDLER_H */
