/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.wizards.AbstractMindMapImportWizard;

public abstract class AbstractMindMapImportPage
extends WizardPage {
    private Text pathInput;
    private Button browseButton;
    private Button currentWorkbookWidget;
    private Button newWorkbookWidget;
    private boolean modifyingPathInput = false;
    private boolean settingTargetPath = false;
    private boolean pathModified = false;
    private Listener widgetListener = null;

    protected AbstractMindMapImportPage(String pageName, String title) {
        super(pageName, title, null);
    }

    protected AbstractMindMapImportWizard getCastedWizard() {
        return (AbstractMindMapImportWizard)super.getWizard();
    }

    protected Control createFileControls(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        Label toFileLabel = new Label(group, 64);
        toFileLabel.setLayoutData((Object)new GridData(1, 2, false, true));
        toFileLabel.setText(WizardMessages.ImportPage_FromFile_text);
        this.pathInput = new Text(group, 2052);
        if (this.getSourcePath() != null) {
            this.pathInput.setText(this.getSourcePath());
        }
        this.pathInput.setLayoutData((Object)new GridData(4, 2, true, true));
        this.hookWidget((Widget)this.pathInput, 24);
        this.hookWidget((Widget)this.pathInput, 15);
        this.browseButton = new Button(group, 8);
        this.browseButton.setText(WizardMessages.ImportPage_Browse_text);
        int width = this.browseButton.computeSize((int)-1, (int)-1).x;
        GridData layoutData = new GridData(3, 2, false, true);
        layoutData.widthHint = Math.max(93, width);
        this.browseButton.setLayoutData((Object)layoutData);
        this.hookWidget((Widget)this.browseButton, 13);
        return group;
    }

    protected Control createDestinationControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(WizardMessages.ImportPage_DestinationGroup_title);
        this.currentWorkbookWidget = new Button((Composite)group, 16);
        this.currentWorkbookWidget.setText(WizardMessages.ImportPage_CurrentWorkbook_text);
        this.currentWorkbookWidget.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.currentWorkbookWidget, 13);
        this.newWorkbookWidget = new Button((Composite)group, 16);
        this.newWorkbookWidget.setText(WizardMessages.ImportPage_NewWorkbook_text);
        this.newWorkbookWidget.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.newWorkbookWidget, 13);
        this.currentWorkbookWidget.setEnabled(this.getCastedWizard().hasTargetWorkbook());
        boolean toNewWorkbook = this.getCastedWizard().isToNewWorkbook();
        this.currentWorkbookWidget.setSelection(!toNewWorkbook);
        this.newWorkbookWidget.setSelection(toNewWorkbook);
        return group;
    }

    public void dispose() {
        super.dispose();
        this.pathInput = null;
        this.browseButton = null;
        this.currentWorkbookWidget = null;
        this.newWorkbookWidget = null;
        this.modifyingPathInput = false;
        this.settingTargetPath = false;
        this.pathModified = false;
    }

    protected void hookWidget(Widget widget, int eventType) {
        if (this.widgetListener == null) {
            this.widgetListener = new WidgetListener();
        }
        widget.addListener(eventType, this.widgetListener);
    }

    protected void handleWidgetEvent(Event event) {
        if (event.widget == this.pathInput) {
            if (event.type == 24) {
                this.pathModified = true;
                if (!this.settingTargetPath) {
                    this.modifyingPathInput = true;
                    this.setSourcePath(this.pathInput.getText());
                    this.modifyingPathInput = false;
                }
                this.updateStatus();
            } else if (event.type == 15) {
                this.pathInput.setSelection(new Point(0, this.pathInput.getText().length()));
            }
        } else if (event.widget == this.browseButton) {
            this.openBrowseDialog();
            this.pathInput.setFocus();
        } else if (event.widget == this.currentWorkbookWidget) {
            this.getCastedWizard().setToNewWorkbook(false);
        } else if (event.widget == this.newWorkbookWidget) {
            this.getCastedWizard().setToNewWorkbook(true);
        }
    }

    protected void openBrowseDialog() {
        FileDialog dialog = this.createBrowseDialog();
        String path = dialog.open();
        if (path != null) {
            this.setSourcePath(path);
        }
    }

    protected FileDialog createBrowseDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(WizardMessages.ImportPage_FileDialog_text);
        if (this.getSourcePath() != null) {
            File file = new File(this.getSourcePath());
            dialog.setFilterPath(file.getParent());
            dialog.setFileName(file.getName());
        }
        return dialog;
    }

    protected void updateStatus() {
        this.setPageComplete(this.isPageCompletable());
        String warningMessage = this.generateWarningMessage();
        if (warningMessage != null) {
            this.setMessage(warningMessage, 2);
        } else {
            this.setMessage(null);
        }
        this.setErrorMessage(this.generateErrorMessage());
    }

    protected String generateWarningMessage() {
        return null;
    }

    protected String generateErrorMessage() {
        if (this.pathModified && !this.hasSourcePath()) {
            return WizardMessages.ImportPage_FileNotExists_message;
        }
        return null;
    }

    protected boolean isPageCompletable() {
        return this.hasSourcePath();
    }

    protected void setSourcePath(String path) {
        this.getCastedWizard().setSourcePath(path);
        if (!this.modifyingPathInput) {
            this.settingTargetPath = true;
            this.pathInput.setText(path);
            this.settingTargetPath = false;
        }
    }

    protected String getSourcePath() {
        return this.getCastedWizard().getSourcePath();
    }

    protected boolean hasSourcePath() {
        return this.getCastedWizard().hasSourcePath();
    }

    private class WidgetListener
    implements Listener {
        private WidgetListener() {
        }

        public void handleEvent(Event event) {
            AbstractMindMapImportPage.this.handleWidgetEvent(event);
        }
    }
}

