/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.ui.branch.IBranchHook;
import org.xmind.ui.internal.branch.BranchPolicyManager;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.Logger;

public class BranchHookFactory {
    private static NullBranchHook NullInstance = null;
    private IConfigurationElement element;
    private boolean singleton;
    private IBranchHook singletonInstance;
    private Expression condition;

    public BranchHookFactory(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.singleton = Boolean.parseBoolean(element.getAttribute("singleton"));
        if (element.getAttribute("class") == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + element, null));
        }
        this.initializeEnablement();
    }

    private void initializeEnablement() {
        IConfigurationElement[] enablements = this.element.getChildren("enablement");
        if (enablements.length == 0) {
            return;
        }
        try {
            this.condition = ExpressionConverter.getDefault().perform(enablements[0]);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to convert expression: " + enablements[0]);
        }
    }

    public IBranchHook createHook(IBranchPart branch) {
        if (this.failsEnablement(branch)) {
            return null;
        }
        if (this.singleton) {
            return this.getSingletonInstance();
        }
        return this.createInstance();
    }

    private IBranchHook createInstance() {
        try {
            return (IBranchHook)this.element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to create branch hook: " + this.element.getAttribute("class"));
            return null;
        }
    }

    private IBranchHook getSingletonInstance() {
        if (this.singletonInstance == null) {
            this.singletonInstance = this.createInstance();
            if (this.singletonInstance == null) {
                if (NullInstance == null) {
                    NullInstance = new NullBranchHook();
                }
                this.singletonInstance = NullInstance;
            }
        }
        return this.singletonInstance;
    }

    private boolean failsEnablement(IBranchPart branch) {
        if (this.condition == null) {
            return false;
        }
        IEvaluationContext context = BranchPolicyManager.createBranchEvaluationContext(branch);
        try {
            EvaluationResult result = this.condition.evaluate(context);
            return result != EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            Logger.log(e, "Evaluation Failed: " + branch);
            return true;
        }
    }

    private static class NullBranchHook
    implements IBranchHook {
        private NullBranchHook() {
        }

        @Override
        public void hook(IBranchPart branch) {
        }

        @Override
        public void unhook(IBranchPart branch) {
        }
    }
}

