/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit.swingui.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ParserLoader
extends ClassLoader {
    private String ParserClassFile;
    private String LexerClassFile;
    private String ParserClassName;
    private String LexerClassName;
    private byte[] parserBytes = null;
    private byte[] lexerBytes = null;
    private Class ParserClass = null;
    private Class LexerClass = null;

    public ParserLoader(String grammarName, String classDir) {
        this.ParserClassName = grammarName + "Parser";
        this.LexerClassName = grammarName + "Lexer";
        this.ParserClassFile = classDir + File.separator + this.ParserClassName + ".class";
        this.LexerClassFile = classDir + File.separator + this.LexerClassName + ".class";
        this.prepareClasses();
    }

    private void prepareClasses() {
        try {
            FileInputStream inLexer = new FileInputStream(this.LexerClassFile);
            this.lexerBytes = new byte[((InputStream)inLexer).available()];
            ((InputStream)inLexer).read(this.lexerBytes);
            ((InputStream)inLexer).close();
            FileInputStream inParser = new FileInputStream(this.ParserClassFile);
            this.parserBytes = new byte[((InputStream)inParser).available()];
            ((InputStream)inParser).read(this.parserBytes);
            ((InputStream)inParser).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.endsWith(this.LexerClassName)) {
            if (this.LexerClass != null) {
                return this.LexerClass;
            }
            this.LexerClass = this.defineClass(null, this.lexerBytes, 0, this.lexerBytes.length);
            this.resolveClass(this.LexerClass);
            return this.LexerClass;
        }
        if (name.endsWith(this.ParserClassName)) {
            if (this.ParserClass != null) {
                return this.ParserClass;
            }
            this.ParserClass = this.defineClass(null, this.parserBytes, 0, this.parserBytes.length);
            this.resolveClass(this.ParserClass);
            return this.ParserClass;
        }
        return this.findSystemClass(name);
    }

    private String stripPackage(String className) {
        return className.substring(className.lastIndexOf("/"));
    }
}

