/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipOutputStream;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.utils.EngineUtils;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;
import org.netbeans.installer.wizard.components.WizardAction;

public class CreateMacOSAppLauncherAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(CreateMacOSAppLauncherAction.class, "CMALA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(CreateMacOSAppLauncherAction.class, "CMALA.description");
    public static final String DEFAULT_ERROR_FAILED_CREATE_LAUNCHER = ResourceUtils.getString(CreateMacOSAppLauncherAction.class, "CMALA.error.failed.create.launcher");
    public static final String ERROR_FAILED_CREATE_LAUNCHER_PROPERTY = "error.failed.create.launcher";
    public static final String APP_NAME_PROPERTY = "nbi.macosx.application.directory.name";
    public static final String DEFAULT_APP_DIRECTORY_NAME = "NetBeans Installer";
    public static final String DEFAULT_ICNS_ICON_NAME = "icon.icns";

    public CreateMacOSAppLauncherAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(ERROR_FAILED_CREATE_LAUNCHER_PROPERTY, DEFAULT_ERROR_FAILED_CREATE_LAUNCHER);
    }

    @Override
    public void execute() {
        LogManager.logEntry("creating the macosx app launcher");
        String targetPath = System.getProperty("nbi.create.bundle.path");
        File targetFile = new File(targetPath);
        Progress progress = new Progress();
        this.getWizardUi().setProgress(progress);
        try {
            Platform platform = Registry.getInstance().getTargetPlatform();
            LauncherProperties properties = new LauncherProperties();
            String appNameSystem = System.getProperty(APP_NAME_PROPERTY);
            String appName = appNameSystem != null ? appNameSystem : DEFAULT_APP_DIRECTORY_NAME;
            String testJDKName = ResourceUtils.getResourceFileName("org/netbeans/installer/utils/applications/TestJDK.class");
            properties.addJar(new LauncherResource(LauncherResource.Type.RELATIVE_LAUNCHER_PARENT, "../Resources/" + appName + "/" + new File(targetPath).getName()));
            properties.setTestJVM(new LauncherResource(LauncherResource.Type.RELATIVE_LAUNCHER_PARENT, "../Resources/" + appName + "/" + testJDKName));
            properties.setJvmArguments(new String[]{"-Xmx256m", "-Xms64m"});
            properties.setMainClass(EngineUtils.getEngineMainClass().getName());
            properties.setTestJVMClass("TestJDK");
            File tmpDirectory = FileUtils.createTempFile(SystemUtils.getTempDirectory(), false, true);
            FileUtils.mkdirs(tmpDirectory);
            File appDirectory = new File(tmpDirectory, appName + ".app");
            File contentsDirectory = new File(appDirectory, "Contents");
            File resDirectory = new File(contentsDirectory, "Resources");
            File macosDirectory = new File(contentsDirectory, "MacOS");
            File appInsideDir = new File(resDirectory, appName);
            File outputFile = new File(macosDirectory, "executable");
            FileUtils.mkdirs(appDirectory);
            FileUtils.mkdirs(contentsDirectory);
            FileUtils.mkdirs(resDirectory);
            FileUtils.mkdirs(appInsideDir);
            FileUtils.mkdirs(macosDirectory);
            String iconName = DEFAULT_ICNS_ICON_NAME;
            properties.setOutput(outputFile, false);
            String iconUri = System.getProperty("nbi.java.application.icon");
            if (iconUri == null) {
                iconUri = "resource:org/netbeans/installer/utils/system/launchers/impl/dockicon.icns";
            }
            File iconFile = FileProxy.getInstance().getFile(iconUri, true);
            File iconFileTarget = new File(resDirectory, DEFAULT_ICNS_ICON_NAME);
            FileUtils.copyFile(iconFile, iconFileTarget);
            properties.getJvmArguments().add("-Xdock:icon=" + LauncherResource.Type.RELATIVE_LAUNCHER_PARENT.getPathString("../Resources/icon.icns"));
            if (System.getProperty("nbi.bundled.jvm.file") != null) {
                LauncherResource jvm = new LauncherResource(new File(System.getProperty("nbi.bundled.jvm.file")));
                properties.addJVM(jvm);
                properties.getJvmArguments().add("-Dnbi.bundled.jvm.file=" + jvm.getAbsolutePath());
            }
            File file = SystemUtils.createLauncher(properties, platform, progress).getOutputFile();
            File testJDKFile = FileProxy.getInstance().getFile("resource:org/netbeans/installer/utils/applications/TestJDK.class", true);
            FileUtils.copyFile(testJDKFile, new File(appInsideDir, testJDKName));
            FileUtils.copyFile(targetFile, new File(appInsideDir, targetFile.getName()));
            File infoplist = new File(contentsDirectory, "Info.plist");
            FileUtils.writeFile(infoplist, StringUtils.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">\n<plist version=\"0.9\">\n  <dict>\n    \n    <key>CFBundleName</key>\n    <string>{0}</string>\n    \n    <key>CFBundleVersion</key>\n    <string>{1}</string>\n    \n    <key>CFBundleExecutable</key>\n    <string>{3}</string>\n    \n    <key>CFBundlePackageType</key>\n    <string>APPL</string>\n    \n    <key>CFBundleShortVersionString</key>\n    <string>{2}</string>\n    \n    <key>CFBundleSignature</key>\n    <string>????</string>\n    \n    <key>CFBundleInfoDictionaryVersion</key>\n    <string>6.0</string>\n    \n    <key>CFBundleIconFile</key>\n    <string>{4}</string>\n  </dict>\n</plist>\n", appName, 1.0, 0, outputFile.getName(), iconFileTarget.getName()));
            String name = targetFile.getName();
            int index = name.lastIndexOf(".");
            String zipName = name.substring(0, index == -1 ? name.length() : index) + ".zip";
            File zipFile = new File(targetFile.getParentFile(), zipName);
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
            FileUtils.zip(appDirectory, zos, appDirectory.getParentFile(), new ArrayList<File>());
            zos.close();
            FileUtils.deleteFile(tmpDirectory, true);
            System.setProperty("nbi.create.bundle.path", zipFile.getPath());
            if (!targetFile.equals(file)) {
                FileUtils.deleteFile(targetFile);
                System.setProperty("nbi.create.bundle.path", file.getPath());
            }
        }
        catch (IOException e) {
            ErrorManager.notifyError(this.getProperty(ERROR_FAILED_CREATE_LAUNCHER_PROPERTY), e);
        }
        catch (DownloadException e) {
            ErrorManager.notifyError(this.getProperty(ERROR_FAILED_CREATE_LAUNCHER_PROPERTY), e);
        }
        LogManager.logExit("finished creating the app launcher");
    }

    @Override
    public boolean canExecuteForward() {
        return !Boolean.getBoolean("nbi.create.bundle.skip.native.launcher");
    }
}

