/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.database.event;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.BibDatabaseContextChangedEvent;
import org.jabref.model.entry.event.FieldChangedEvent;

public class CoarseChangeFilter {
    private final EventBus eventBus = new EventBus();
    private String lastFieldChanged;
    private final BibDatabaseContext context;

    public CoarseChangeFilter(BibDatabaseContext bibDatabaseContext) {
        bibDatabaseContext.getDatabase().registerListener(this);
        bibDatabaseContext.getMetaData().registerListener(this);
        this.context = bibDatabaseContext;
    }

    @Subscribe
    public synchronized void listen(BibDatabaseContextChangedEvent event) {
        if (!(event instanceof FieldChangedEvent)) {
            this.eventBus.post(event);
        } else {
            boolean isEditOnNewField;
            FieldChangedEvent fieldChange = (FieldChangedEvent)event;
            boolean bl = isEditOnNewField = this.lastFieldChanged == null || !this.lastFieldChanged.equals(fieldChange.getFieldName());
            if (fieldChange.getDelta() > 1 || isEditOnNewField) {
                this.lastFieldChanged = fieldChange.getFieldName();
                this.eventBus.post(event);
            }
        }
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterListener(Object listener) {
        this.eventBus.unregister(listener);
    }

    public void shutdown() {
        this.context.getDatabase().unregisterListener(this);
        this.context.getMetaData().unregisterListener(this);
    }
}

