/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.strings.StringUtil;

public class PagesChecker
implements ValueChecker {
    private static final String PAGES_EXP_BIBTEX = "\\A\\d+(?:\\+|\\-{2}\\d+)?(?:,\\d+(?:\\+|\\-{2}\\d+)?)*\\z";
    private static final String PAGES_EXP_BIBLATEX = "\\A\\d+(?:\\+|\\-{1,2}\\d+)?(?:,\\d+(?:\\+|\\-{1,2}\\d+)?)*\\z";
    private final Predicate<String> isValidPageNumber;

    public PagesChecker(BibDatabaseContext databaseContext) {
        this.isValidPageNumber = databaseContext.isBiblatexMode() ? Pattern.compile(PAGES_EXP_BIBLATEX).asPredicate() : Pattern.compile(PAGES_EXP_BIBTEX).asPredicate();
    }

    @Override
    public Optional<String> checkValue(String value) {
        if (StringUtil.isBlank(value)) {
            return Optional.empty();
        }
        if (!this.isValidPageNumber.test(value.trim())) {
            return Optional.of(Localization.lang("should contain a valid page number range", new String[0]));
        }
        return Optional.empty();
    }
}

