/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search.rules.describer;

import org.jabref.gui.search.rules.describer.ContainsAndRegexBasedSearchRuleDescriber;
import org.jabref.gui.search.rules.describer.GrammarBasedSearchRuleDescriber;
import org.jabref.gui.search.rules.describer.SearchDescriber;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.search.rules.ContainBasedSearchRule;
import org.jabref.model.search.rules.GrammarBasedSearchRule;
import org.jabref.model.search.rules.RegexBasedSearchRule;

public class SearchDescribers {
    private SearchDescribers() {
    }

    public static SearchDescriber getSearchDescriberFor(SearchQuery searchQuery) {
        if (searchQuery.getRule() instanceof GrammarBasedSearchRule) {
            GrammarBasedSearchRule grammarBasedSearchRule = (GrammarBasedSearchRule)searchQuery.getRule();
            return new GrammarBasedSearchRuleDescriber(grammarBasedSearchRule.isCaseSensitiveSearch(), grammarBasedSearchRule.isRegExpSearch(), grammarBasedSearchRule.getTree());
        }
        if (searchQuery.getRule() instanceof ContainBasedSearchRule) {
            ContainBasedSearchRule containBasedSearchRule = (ContainBasedSearchRule)searchQuery.getRule();
            return new ContainsAndRegexBasedSearchRuleDescriber(containBasedSearchRule.isCaseSensitive(), false, searchQuery.getQuery());
        }
        if (searchQuery.getRule() instanceof RegexBasedSearchRule) {
            RegexBasedSearchRule regexBasedSearchRule = (RegexBasedSearchRule)searchQuery.getRule();
            return new ContainsAndRegexBasedSearchRuleDescriber(regexBasedSearchRule.isCaseSensitive(), true, searchQuery.getQuery());
        }
        throw new IllegalStateException("Cannot find a describer for searchRule " + searchQuery.getRule() + " and query " + searchQuery.getQuery());
    }
}

