/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.keyboard;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyEvent;
import javax.inject.Inject;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.AbstractController;
import org.jabref.gui.DialogService;
import org.jabref.gui.IconTheme;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.keyboard.KeyBindingViewModel;
import org.jabref.gui.keyboard.KeyBindingsDialogViewModel;
import org.jabref.gui.util.RecursiveTreeItem;
import org.jabref.gui.util.ViewModelTreeTableCellFactory;
import org.jabref.preferences.PreferencesService;

public class KeyBindingsDialogController
extends AbstractController<KeyBindingsDialogViewModel> {
    @FXML
    private TreeTableView<KeyBindingViewModel> keyBindingsTable;
    @FXML
    private TreeTableColumn<KeyBindingViewModel, String> actionColumn;
    @FXML
    private TreeTableColumn<KeyBindingViewModel, String> shortcutColumn;
    @FXML
    private TreeTableColumn<KeyBindingViewModel, String> resetColumn;
    @Inject
    private KeyBindingRepository keyBindingRepository;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferences;

    @FXML
    private void initialize() {
        this.viewModel = new KeyBindingsDialogViewModel(this.keyBindingRepository, this.dialogService, this.preferences);
        this.keyBindingsTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        ((KeyBindingsDialogViewModel)this.viewModel).selectedKeyBindingProperty().bind((ObservableValue)EasyBind.monadic(this.keyBindingsTable.selectionModelProperty()).flatMap(SelectionModel::selectedItemProperty).selectProperty(TreeItem::valueProperty));
        this.keyBindingsTable.setOnKeyPressed(evt -> ((KeyBindingsDialogViewModel)this.viewModel).setNewBindingForCurrent((KeyEvent)evt));
        this.keyBindingsTable.rootProperty().bind(EasyBind.map(((KeyBindingsDialogViewModel)this.viewModel).rootKeyBindingProperty(), keybinding -> new RecursiveTreeItem<KeyBindingViewModel>((KeyBindingViewModel)keybinding, KeyBindingViewModel::getChildren)));
        this.actionColumn.setCellValueFactory(cellData -> ((KeyBindingViewModel)cellData.getValue().getValue()).nameProperty());
        this.shortcutColumn.setCellValueFactory(cellData -> ((KeyBindingViewModel)cellData.getValue().getValue()).shownBindingProperty());
        this.resetColumn.setCellFactory(new ViewModelTreeTableCellFactory().withGraphic(keyBinding -> keyBinding.getIcon().map(IconTheme.JabRefIcon::getGraphicNode).orElse(null)).withOnMouseClickedEvent(keyBinding -> evt -> keyBinding.resetToDefault()));
    }

    @FXML
    private void closeDialog() {
        this.getStage().close();
    }

    @FXML
    private void saveKeyBindingsAndCloseDialog() {
        ((KeyBindingsDialogViewModel)this.viewModel).saveKeyBindings();
        this.closeDialog();
    }

    @FXML
    private void setDefaultBindings() {
        ((KeyBindingsDialogViewModel)this.viewModel).resetToDefault();
    }
}

