/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.http.impl.client;

import com.microsoft.applicationinsights.core.dependencies.http.HttpException;
import com.microsoft.applicationinsights.core.dependencies.http.HttpHost;
import com.microsoft.applicationinsights.core.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.core.dependencies.http.client.ClientProtocolException;
import com.microsoft.applicationinsights.core.dependencies.http.client.config.RequestConfig;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.CloseableHttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.Configurable;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpExecutionAware;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpRequestWrapper;
import com.microsoft.applicationinsights.core.dependencies.http.client.protocol.HttpClientContext;
import com.microsoft.applicationinsights.core.dependencies.http.conn.ClientConnectionManager;
import com.microsoft.applicationinsights.core.dependencies.http.conn.ClientConnectionRequest;
import com.microsoft.applicationinsights.core.dependencies.http.conn.HttpClientConnectionManager;
import com.microsoft.applicationinsights.core.dependencies.http.conn.ManagedClientConnection;
import com.microsoft.applicationinsights.core.dependencies.http.conn.routing.HttpRoute;
import com.microsoft.applicationinsights.core.dependencies.http.conn.scheme.SchemeRegistry;
import com.microsoft.applicationinsights.core.dependencies.http.impl.DefaultConnectionReuseStrategy;
import com.microsoft.applicationinsights.core.dependencies.http.impl.client.CloseableHttpClient;
import com.microsoft.applicationinsights.core.dependencies.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.microsoft.applicationinsights.core.dependencies.http.impl.execchain.MinimalClientExec;
import com.microsoft.applicationinsights.core.dependencies.http.params.BasicHttpParams;
import com.microsoft.applicationinsights.core.dependencies.http.params.HttpParams;
import com.microsoft.applicationinsights.core.dependencies.http.protocol.BasicHttpContext;
import com.microsoft.applicationinsights.core.dependencies.http.protocol.HttpContext;
import com.microsoft.applicationinsights.core.dependencies.http.protocol.HttpRequestExecutor;
import com.microsoft.applicationinsights.core.dependencies.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

