/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.GeometryParsers;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class Lines
extends SimpleProcProvider {
    public Lines() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "line_");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return double[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Line;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            if (val == null) {
                return;
            }
            double[] point = (double[])val;
            if (point.length != 3) {
                throw new IOException("invalid length");
            }
            buffer.append("{").append(Double.toString(point[0])).append(',').append(Double.toString(point[1])).append("),").append(Double.toString(point[2])).append('}');
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Line;
        }

        @Override
        public Class<?> getOutputType() {
            return double[].class;
        }

        public double[] decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            return GeometryParsers.INSTANCE.parseLine(buffer);
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return double[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Line;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                double[] line = (double[])val;
                if (line.length != 3) {
                    throw new IOException("invalid length");
                }
                buffer.writeInt(24);
                buffer.writeDouble(line[0]);
                buffer.writeDouble(line[1]);
                buffer.writeDouble(line[2]);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Line;
        }

        @Override
        public Class<?> getOutputType() {
            return double[].class;
        }

        public double[] decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 24) {
                throw new IOException("invalid length " + length);
            }
            return new double[]{buffer.readDouble(), buffer.readDouble(), buffer.readDouble()};
        }
    }
}

