# This program tests the tcl3dVectorFromLinspace command.

package require tcl3d

set v [tcl3dVectorFromLinspace float 1 4 4]
puts "float vector of length 4 from 1 to 4"
tcl3dVectorPrint $v 4
puts ""

set v [tcl3dVectorFromLinspace double 1 2 5]
puts "double vector of length 5 from 1 to 2"
tcl3dVectorPrint $v 5
puts ""

set v [tcl3dVectorFromLinspace GLfloat -1 2 3]
puts "GLfloat vector of length 3 from -1 to 2"
tcl3dVectorPrint $v 3
puts ""

set v [tcl3dVectorFromLinspace GLdouble 0 0.1 5]
puts "GLdouble vector of length 5 from 0 to 0.1"
tcl3dVectorPrint $v 5
puts ""

set v [tcl3dVectorFromLinspace GLubyte 0 20 5]
puts "GLubyte vector of length 5 from 0 to 20"
tcl3dVectorPrint $v 5 "%d"
puts ""

set retVal [catch {set v [tcl3dVectorFromLinspace int 0 0.1 5]}]
if { $retVal } {
    puts "Calling \"tcl3dVectorFromLinspace int 0 0.1 5\" generated an error:"
    puts $errorInfo
    puts ""
}

set retVal [catch {set v [tcl3dVectorFromLinspace float 4 3 5]}]
if { $retVal } {
    puts "Calling \"tcl3dVectorFromLinspace float 4 3 5\" generated an error:"
    puts $errorInfo
    puts ""
}

set retVal [catch {set v [tcl3dVectorFromLinspace float 0 3 -5]}]
if { $retVal } {
    puts "Calling \"tcl3dVectorFromLinspace float 0 3 -5\" generated an error:"
    puts $errorInfo
    puts ""
}

exit
