/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.gradle.api.NonNullApi;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.build.event.BuildEventListenerFactory;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.OperationResultPostProcessor;
import org.gradle.internal.build.event.OperationResultPostProcessorFactory;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.problems.buildtree.ProblemReporter;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.provider.runner.AggregatingProblemConsumer;
import org.gradle.tooling.internal.provider.runner.BuildOperationMapper;
import org.gradle.tooling.internal.provider.runner.BuildPhaseOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientBuildEventGenerator;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTestOutputOperationListener;
import org.gradle.tooling.internal.provider.runner.FileDownloadOperationMapper;
import org.gradle.tooling.internal.provider.runner.OperationDependenciesResolver;
import org.gradle.tooling.internal.provider.runner.PluginApplicationTracker;
import org.gradle.tooling.internal.provider.runner.ProblemsProgressEventConsumer;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;
import org.gradle.tooling.internal.provider.runner.ProjectConfigurationOperationMapper;
import org.gradle.tooling.internal.provider.runner.ProjectConfigurationTracker;
import org.gradle.tooling.internal.provider.runner.TaskOperationMapper;
import org.gradle.tooling.internal.provider.runner.TaskOriginTracker;
import org.gradle.tooling.internal.provider.runner.TestOperationMapper;
import org.gradle.tooling.internal.provider.runner.TestTaskExecutionTracker;
import org.gradle.tooling.internal.provider.runner.TransformOperationMapper;
import org.gradle.tooling.internal.provider.runner.WorkItemOperationMapper;

@NonNullApi
public class ToolingApiBuildEventListenerFactory
implements BuildEventListenerFactory,
ProblemReporter {
    private final BuildOperationAncestryTracker ancestryTracker;
    private final BuildOperationIdFactory idFactory;
    private final List<OperationResultPostProcessorFactory> postProcessorFactories;
    private Optional<AggregatingProblemConsumer> problemAggregator = Optional.empty();
    private static final BuildOperationListener NO_OP = new BuildOperationListener(){

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        }

        public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        }
    };

    ToolingApiBuildEventListenerFactory(BuildOperationAncestryTracker ancestryTracker, BuildOperationIdFactory idFactory, List<OperationResultPostProcessorFactory> postProcessorFactories) {
        this.ancestryTracker = ancestryTracker;
        this.idFactory = idFactory;
        this.postProcessorFactories = postProcessorFactories;
    }

    public Iterable<Object> createListeners(BuildEventSubscriptions subscriptions, BuildEventConsumer consumer) {
        if (!subscriptions.isAnyOperationTypeRequested()) {
            return ImmutableList.of();
        }
        ProgressEventConsumer progressEventConsumer = new ProgressEventConsumer(consumer, this.ancestryTracker);
        ImmutableList.Builder listeners = ImmutableList.builder();
        if (subscriptions.isRequested(OperationType.TEST) && subscriptions.isRequested(OperationType.TEST_OUTPUT)) {
            listeners.add((Object)new ClientForwardingTestOutputOperationListener(progressEventConsumer, this.idFactory));
        }
        if (subscriptions.isRequested(OperationType.BUILD_PHASE)) {
            listeners.add((Object)new BuildPhaseOperationListener(progressEventConsumer, this.idFactory));
        }
        listeners.add((Object)this.createClientBuildEventGenerator(subscriptions, consumer, progressEventConsumer));
        return listeners.build();
    }

    private ClientBuildEventGenerator createClientBuildEventGenerator(BuildEventSubscriptions subscriptions, BuildEventConsumer consumer, ProgressEventConsumer progressEventConsumer) {
        BuildOperationListener buildListener = this.createBuildOperationListener(subscriptions, progressEventConsumer);
        OperationDependenciesResolver operationDependenciesResolver = new OperationDependenciesResolver();
        PluginApplicationTracker pluginApplicationTracker = new PluginApplicationTracker(this.ancestryTracker);
        TestTaskExecutionTracker testTaskTracker = new TestTaskExecutionTracker(this.ancestryTracker);
        ProjectConfigurationTracker projectConfigurationTracker = new ProjectConfigurationTracker(this.ancestryTracker, pluginApplicationTracker);
        TaskOriginTracker taskOriginTracker = new TaskOriginTracker(pluginApplicationTracker);
        TransformOperationMapper transformOperationMapper = new TransformOperationMapper(operationDependenciesResolver);
        operationDependenciesResolver.addLookup(transformOperationMapper);
        List<OperationResultPostProcessor> postProcessors = this.createPostProcessors(subscriptions, consumer);
        TaskOperationMapper taskOperationMapper = new TaskOperationMapper(postProcessors, taskOriginTracker, operationDependenciesResolver);
        operationDependenciesResolver.addLookup(taskOperationMapper);
        ImmutableList mappers = ImmutableList.of((Object)new FileDownloadOperationMapper(), (Object)new TestOperationMapper(testTaskTracker), (Object)new ProjectConfigurationOperationMapper(projectConfigurationTracker), (Object)taskOperationMapper, (Object)transformOperationMapper, (Object)new WorkItemOperationMapper());
        return new ClientBuildEventGenerator(progressEventConsumer, subscriptions, (List<? extends BuildOperationMapper<?, ?>>)mappers, buildListener);
    }

    private List<OperationResultPostProcessor> createPostProcessors(BuildEventSubscriptions subscriptions, BuildEventConsumer consumer) {
        return (List)this.postProcessorFactories.stream().map(factory -> factory.createProcessors(subscriptions, consumer)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private BuildOperationListener createBuildOperationListener(BuildEventSubscriptions subscriptions, ProgressEventConsumer progressEventConsumer) {
        if (subscriptions.isRequested(OperationType.PROBLEMS)) {
            return this.createProblemsProgressConsumer(progressEventConsumer);
        }
        if (subscriptions.isRequested(OperationType.GENERIC)) {
            return new ClientForwardingBuildOperationListener(progressEventConsumer);
        }
        return NO_OP;
    }

    @Nonnull
    private ProblemsProgressEventConsumer createProblemsProgressConsumer(ProgressEventConsumer progressEventConsumer) {
        Supplier<OperationIdentifier> operationIdentifierSupplier = () -> new OperationIdentifier(this.idFactory.nextId());
        AggregatingProblemConsumer aggregator = new AggregatingProblemConsumer(progressEventConsumer, operationIdentifierSupplier);
        this.problemAggregator = Optional.of(aggregator);
        return new ProblemsProgressEventConsumer(progressEventConsumer, operationIdentifierSupplier, aggregator);
    }

    public String getId() {
        return "problems";
    }

    public void report(File reportDir, ProblemReporter.ProblemConsumer validationFailures) {
        this.problemAggregator.ifPresent(AggregatingProblemConsumer::sendProblemSummaries);
    }
}

