/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import net.yura.mobile.logging.Logger;

public class FileUtil {
    public static final long RECENT_PICTURE_TIME_INTERVAL = 30000L;
    public static final String ROOT_PREX = "file:///";
    public static final int TYPE_ALL = 0;
    public static final int TYPE_FOLDER = 1;
    public static final int TYPE_PICTURE = 2;
    public static final int TYPE_AUDIO = 3;
    public static final int TYPE_VIDEO = 4;
    public static final int TYPE_OTHER = 5;
    private static final int[] TYPES_KNOWN = new int[]{2, 3, 4};
    public static final String[][] EXTS_FILENAME = new String[][]{{"JPG", "JPEG", "JPE", "PNG", "GIF", "BMP", "PNG.REM"}, {"AMR", "MP3", "MP4", "AAC", "WMA", "WAV", "MID", "MIDI", "M4A"}, {"3GP"}};

    public static void close(Object fc) {
        block6: {
            if (fc != null) {
                try {
                    if (fc instanceof Connection) {
                        ((Connection)fc).close();
                        break block6;
                    }
                    if (fc instanceof InputStream) {
                        ((InputStream)fc).close();
                        break block6;
                    }
                    if (fc instanceof OutputStream) {
                        ((OutputStream)fc).close();
                        break block6;
                    }
                    throw new RuntimeException();
                }
                catch (IOException ioe) {
                    Logger.info("cant close " + fc, ioe);
                }
            }
        }
    }

    public static Vector listFiles(String dir, int filter, boolean recent) {
        Vector files = new Vector();
        try {
            if (ROOT_PREX.equals(dir)) {
                Enumeration e = FileSystemRegistry.listRoots();
                while (e.hasMoreElements()) {
                    files.addElement(e.nextElement());
                }
            } else {
                files.addElement("../");
                FileConnection fc = (FileConnection)Connector.open((String)dir, (int)1);
                if (fc.exists() && fc.isDirectory()) {
                    long earliestAcceptableTime = System.currentTimeMillis() - 30000L;
                    int dircount = 1;
                    Enumeration enu = fc.list("*", true);
                    while (enu.hasMoreElements()) {
                        String fname = (String)enu.nextElement();
                        if (FileUtil.isFileType(fname, 1)) {
                            files.insertElementAt(fname, dircount);
                            ++dircount;
                            continue;
                        }
                        if (!FileUtil.isFileType(fname, filter) || recent && FileUtil.getLastModified(dir + fname) < earliestAcceptableTime) continue;
                        files.addElement(fname);
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.warn("error moving dir", ex);
        }
        return files;
    }

    public static int getFileType(String fname) {
        String name = fname.toUpperCase();
        if (name.endsWith("/")) {
            return 1;
        }
        for (int i = 0; i < EXTS_FILENAME.length; ++i) {
            for (int j = 0; j < EXTS_FILENAME[i].length; ++j) {
                if (!name.endsWith(EXTS_FILENAME[i][j])) continue;
                return TYPES_KNOWN[i];
            }
        }
        return 5;
    }

    public static boolean isFileType(String fname, int filetype) {
        String name = fname.toUpperCase();
        if (filetype == 0) {
            return true;
        }
        if (filetype == 1) {
            return name.endsWith("/");
        }
        if (filetype == 2 || filetype == 3 || filetype == 4) {
            int j = filetype - 2;
            for (int i = 0; i < EXTS_FILENAME[j].length; ++i) {
                if (!name.endsWith(EXTS_FILENAME[j][i])) continue;
                return true;
            }
        } else if (filetype == 5) {
            return FileUtil.getFileType(fname) == 5;
        }
        return false;
    }

    public static String extractPath(String fullName) {
        return fullName.substring(0, fullName.lastIndexOf(47) + 1);
    }

    public static String extractName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(47) + 1);
    }

    public static InputStream getInputStreamFromFileConnector(String fileName) throws IOException {
        return FileUtil.getReadFileConnection(fileName).openInputStream();
    }

    public static FileConnection getWriteFileConnection(String fullName) throws IOException {
        FileConnection fc = (FileConnection)Connector.open((String)fullName, (int)3);
        if (fc != null) {
            if (fc.exists()) {
                fc.delete();
            }
            fc.create();
            fc.setWritable(true);
            return fc;
        }
        throw new IOException();
    }

    public static FileConnection getReadFileConnection(String fullName) throws IOException {
        FileConnection fc = (FileConnection)Connector.open((String)fullName, (int)1);
        if (fc != null) {
            return fc;
        }
        throw new IOException();
    }

    public static int getFileSize(String fileName) {
        FileConnection fc = null;
        int fileSize = -1;
        try {
            fc = (FileConnection)Connector.open((String)fileName, (int)1);
            if (fc != null && fc.exists()) {
                fileSize = (int)fc.fileSize();
                fc.close();
            }
        }
        catch (Exception e) {
            Logger.warn("cant get size " + fileName, e);
        }
        return fileSize;
    }

    public static long getLastModified(String fileName) {
        FileConnection fc = null;
        long lastModified = -1L;
        try {
            fc = (FileConnection)Connector.open((String)fileName, (int)1);
            if (fc != null && fc.exists()) {
                lastModified = fc.lastModified();
            }
        }
        catch (Exception e) {
            Logger.warn("error " + fileName, e);
        }
        FileUtil.close(fc);
        return lastModified;
    }

    public static boolean localFileExists(String filePath) {
        if (filePath == null) {
            return false;
        }
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)filePath, (int)1);
            if (fc != null) {
                return fc.exists();
            }
            return false;
        }
        catch (Exception e) {
            Logger.info("error " + filePath, e);
            return false;
        }
    }

    public static boolean mkDir(String dirName) {
        if (!dirName.trim().endsWith("/")) {
            return false;
        }
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)dirName, (int)3);
            if (fc != null) {
                if (!fc.exists()) {
                    fc.mkdir();
                }
                fc.close();
                fc = null;
                return true;
            }
        }
        catch (Exception e) {
            Logger.warn("cant make " + dirName, e);
        }
        return false;
    }

    public static Enumeration getDirectoryFiles(String dir) {
        Enumeration en = null;
        if (dir == null || !dir.trim().endsWith("/")) {
            return null;
        }
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)dir, (int)1);
            en = fc.list();
        }
        catch (Exception ex) {
            Logger.info("error " + dir, ex);
        }
        return en;
    }

    public static void deleteFile(String path) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)path, (int)3);
            if (fc != null && fc.exists()) {
                if (fc.isDirectory()) {
                    Enumeration enu = fc.list();
                    while (enu.hasMoreElements()) {
                        FileUtil.deleteFile(path + (String)enu.nextElement());
                    }
                }
                fc.delete();
                fc.close();
            }
        }
        catch (Exception e) {
            Logger.warn("cant del " + path, e);
        }
    }

    public static byte[] readFile(String fileName, long startPos, int length) {
        byte[] buffer = null;
        FileConnection fc = null;
        InputStream is = null;
        try {
            fc = FileUtil.getReadFileConnection(fileName);
            if (fc != null && fc.exists() && fc.canRead()) {
                if (length == -1) {
                    length = (int)fc.fileSize();
                } else if ((long)length >= fc.fileSize() - startPos) {
                    length = (int)(fc.fileSize() - startPos);
                }
                if (length > 0) {
                    buffer = new byte[length];
                    is = fc.openInputStream();
                    is.skip(startPos);
                    is.read(buffer, 0, length);
                    is.close();
                    is = null;
                }
                fc.close();
                return buffer;
            }
        }
        catch (Exception e) {
            Logger.warn("cant read " + fileName + " " + startPos + " " + length, e);
        }
        return null;
    }

    public static String writeFile(String fullname, boolean append, int fileStartPos, byte[] data, int dataStartPos, int dataLength) {
        return FileUtil.writeFile(fullname, append, false, fileStartPos, data, dataStartPos, dataLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(String fullname, boolean append, boolean deleteExisting, int fileStartPos, byte[] data, int dataStartPos, int dataLength) {
        String dstname;
        OutputStream os;
        FileConnection fc;
        block9: {
            fc = null;
            os = null;
            dstname = fullname;
            try {
                fc = FileUtil.getWriteFileConnection(fullname);
                if (fc == null) break block9;
                if (!fc.exists()) {
                    fc.create();
                    fc.setWritable(true);
                } else if (deleteExisting) {
                    FileUtil.deleteFile(fullname);
                    fc.create();
                    fc.setWritable(true);
                } else if (!append) {
                    fc.close();
                    fc = null;
                    fc = FileUtil.findAvailableFile(fullname);
                    dstname = fc.getURL();
                }
                os = fc.openOutputStream((long)fileStartPos);
                os.write(data, dataStartPos, dataLength);
                os.flush();
            }
            catch (Exception e) {
                try {
                    dstname = null;
                    Logger.warn("error " + fullname + " " + append + " " + deleteExisting + " " + fileStartPos + " " + dataStartPos + " " + dataLength, e);
                }
                catch (Throwable throwable) {
                    FileUtil.close(os);
                    FileUtil.close(fc);
                    throw throwable;
                }
                FileUtil.close(os);
                FileUtil.close(fc);
            }
        }
        FileUtil.close(os);
        FileUtil.close(fc);
        return dstname;
    }

    private static FileConnection findAvailableFile(String fileName) throws Exception {
        FileConnection fc = null;
        String bef = fileName.substring(0, fileName.lastIndexOf(46));
        String end = fileName.substring(fileName.lastIndexOf(46));
        String fname = null;
        int j = 0;
        while (true) {
            if (!(fc = (FileConnection)Connector.open((String)(fname = bef + "_" + j + end), (int)3)).exists()) {
                fc.create();
                fc.setWritable(true);
                return fc;
            }
            fc.close();
            ++j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String srcfileName, String srcFullName, String desFullPath) {
        boolean writesucc;
        OutputStream dos;
        InputStream dis;
        FileConnection src;
        FileConnection dst;
        block7: {
            int COPY_BLOCK_SIZE = 10240;
            dst = null;
            src = null;
            dis = null;
            dos = null;
            writesucc = false;
            try {
                src = (FileConnection)Connector.open((String)srcFullName, (int)3);
                if (src == null || !src.exists()) break block7;
                dst = (FileConnection)Connector.open((String)(desFullPath + srcfileName), (int)3);
                if (dst.exists()) {
                    dst = FileUtil.findAvailableFile(desFullPath + srcfileName);
                } else {
                    dst.create();
                    dst.setWritable(true);
                }
                dis = src.openInputStream();
                dos = dst.openOutputStream();
                byte[] data = new byte[COPY_BLOCK_SIZE];
                int i = 0;
                while ((i = dis.read(data, 0, COPY_BLOCK_SIZE)) != -1) {
                    dos.write(data, 0, i);
                    dos.flush();
                }
                writesucc = true;
            }
            catch (Exception e) {
                try {
                    writesucc = false;
                    Logger.warn("copy error " + srcfileName + " " + srcFullName + " " + desFullPath, e);
                }
                catch (Throwable throwable) {
                    FileUtil.close(dis);
                    FileUtil.close(dos);
                    FileUtil.close(src);
                    FileUtil.close(dst);
                    throw throwable;
                }
                FileUtil.close(dis);
                FileUtil.close(dos);
                FileUtil.close(src);
                FileUtil.close(dst);
            }
        }
        FileUtil.close(dis);
        FileUtil.close(dos);
        FileUtil.close(src);
        FileUtil.close(dst);
        return writesucc;
    }

    public static void copyFile(String source, String destination) {
        try {
            byte[] sourceData = FileUtil.readFile(source, 0L, -1);
            FileUtil.writeFile(destination, false, true, 0, sourceData, 0, sourceData.length);
        }
        catch (Exception e) {
            Logger.warn("copy error " + source + " " + destination, e);
        }
    }
}

