/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ColorFormatter
extends Formatter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_LIGHT_GARY = "\u001b[37m";
    public static final String ANSI_DARK_GRAY = "\u001b[1;30m";
    public static final String ANSI_LIGHT_RED = "\u001b[1;31m";
    public static final String ANSI_LIGHT_GREEN = "\u001b[1;32m";
    public static final String ANSI_LIGHT_YELLOW = "\u001b[1;33m";
    public static final String ANSI_LIGHT_BLUE = "\u001b[1;34m";
    public static final String ANSI_LIGHT_PURPLE = "\u001b[1;35m";
    public static final String ANSI_LIGHT_CYAN = "\u001b[1;36m";
    public static final String ANSI_WHITE = "\u001b[1;37m";
    private Formatter parent;

    public ColorFormatter(Formatter parent) {
        this.parent = parent;
    }

    public String format(LogRecord record) {
        return ColorFormatter.getColor(record.getLevel().intValue()) + this.parent.format(record) + ANSI_RESET;
    }

    public static String getColor(int level) {
        if (level >= Level.SEVERE.intValue()) {
            return ANSI_RED;
        }
        if (level >= Level.WARNING.intValue()) {
            return ANSI_RED;
        }
        if (level >= Level.INFO.intValue()) {
            return "";
        }
        if (level >= Level.CONFIG.intValue()) {
            return ANSI_YELLOW;
        }
        if (level >= Level.FINE.intValue()) {
            return ANSI_PURPLE;
        }
        if (level >= Level.FINER.intValue()) {
            return ANSI_BLUE;
        }
        return ANSI_CYAN;
    }

    public static void main(String[] args) {
        System.out.println("\u001b[30mBLACK\u001b[0m\n\u001b[31mRED\u001b[0m\n\u001b[32mGREEN\u001b[0m\n\u001b[33mYELLOW\u001b[0m\n\u001b[34mBLUE\u001b[0m\n\u001b[35mPURPLE\u001b[0m\n\u001b[36mCYAN\u001b[0m\n\u001b[37mLIGHT_GRAY\u001b[0m\n\u001b[1;30mDARK_GRAY\u001b[0m\n\u001b[1;31mLIGHT_RED\u001b[0m\n\u001b[1;32mLIGHT_GREEN\u001b[0m\n\u001b[1;33mLIGHT_YELLOW\u001b[0m\n\u001b[1;34mLIGHT_BLUE\u001b[0m\n\u001b[1;35mLIGHT_PURPLE\u001b[0m\n\u001b[1;36mLIGHT_CYAN\u001b[0m\n\u001b[1;37mWHITE\u001b[0m\n");
    }
}

