/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.IntIteratorOverIteratingRLW32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import java.util.Iterator;

public class IteratorUtil32 {
    public static IntIterator toSetBitsIntIterator(IteratingRLW32 i) {
        return new IntIteratorOverIteratingRLW32(i);
    }

    public static Iterator<Integer> toSetBitsIterator(final IteratingRLW32 i) {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = IteratorUtil32.toSetBitsIntIterator(i);
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return new Integer(this.under.next());
            }

            @Override
            public void remove() {
            }
        };
    }

    public static void materialize(IteratingRLW32 i, BitmapStorage32 c) {
        do {
            if (i.getRunningLength() > 0) {
                c.addStreamOfEmptyWords(i.getRunningBit(), i.getRunningLength());
            }
            for (int k = 0; k < i.getNumberOfLiteralWords(); ++k) {
                c.add(i.getLiteralWordAt(k));
            }
        } while (i.next());
    }

    public static int cardinality(IteratingRLW32 i) {
        int answer = 0;
        do {
            if (i.getRunningBit()) {
                answer += i.getRunningLength() * 32;
            }
            for (int k = 0; k < i.getNumberOfLiteralWords(); ++k) {
                answer += Long.bitCount(i.getLiteralWordAt(k));
            }
        } while (i.next());
        return answer;
    }

    public static IteratingRLW32[] toIterators(EWAHCompressedBitmap32 ... x) {
        IteratingRLW32[] X = new IteratingRLW32[x.length];
        for (int k = 0; k < X.length; ++k) {
            X[k] = new IteratingBufferedRunningLengthWord32(x[k]);
        }
        return X;
    }

    public static long materialize(IteratingRLW32 i, BitmapStorage32 c, int Max2) {
        int origMax = Max2;
        do {
            if (i.getRunningLength() > 0) {
                int L = i.getRunningLength();
                if (L > Max2) {
                    L = Max2;
                }
                c.addStreamOfEmptyWords(i.getRunningBit(), L);
                Max2 -= L;
            }
            long L = i.getNumberOfLiteralWords();
            int k = 0;
            while ((long)k < L) {
                c.add(i.getLiteralWordAt(k));
                ++k;
            }
        } while (Max2 > 0 && i.next());
        return origMax - Max2;
    }

    public static EWAHCompressedBitmap32 materialize(IteratingRLW32 i) {
        EWAHCompressedBitmap32 ewah = new EWAHCompressedBitmap32();
        IteratorUtil32.materialize(i, ewah);
        return ewah;
    }
}

