/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.FastAggregation32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32;
import com.googlecode.javaewah32.IteratorUtil32;
import java.text.DecimalFormat;

public class BenchmarkXOR32 {
    public static void main(String[] args) {
        BenchmarkXOR32.test(10, 18, 1);
    }

    public static void test(int N, int nbr, int repeat) {
        long bogus = 0L;
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; ++sparsity) {
            for (int times = 0; times < 2; ++times) {
                Object ewahor;
                Object[] ewahcp;
                int r;
                String line = "";
                line = line + sparsity;
                int[][] data = new int[N][];
                int Max2 = 1 << nbr + sparsity;
                for (int k = 0; k < N; ++k) {
                    data[k] = cdg.generateClustered(1 << nbr, Max2);
                }
                LogicalElement[] ewah = new EWAHCompressedBitmap32[N];
                for (int k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap32();
                    for (int x = 0; x < data[k].length; ++x) {
                        ((EWAHCompressedBitmap32)ewah[k]).set(data[k][x]);
                    }
                    data[k] = null;
                }
                EWAHCompressedBitmap32 answer = ewah[0].xor(ewah[1]);
                for (int k = 2; k < ewah.length; ++k) {
                    answer = answer.xor((EWAHCompressedBitmap32)ewah[k]);
                }
                EWAHCompressedBitmap32 ewahor3 = (EWAHCompressedBitmap32)FastAggregation.xor((LogicalElement[])ewah);
                if (!answer.equals(ewahor3)) {
                    throw new RuntimeException("bug FastAggregation.xor");
                }
                EWAHCompressedBitmap32 ewahor2 = FastAggregation32.bufferedxor(65536, (EWAHCompressedBitmap32[])ewah);
                if (!answer.equals(ewahor2)) {
                    throw new RuntimeException("bug FastAggregation.bufferedxor ");
                }
                EWAHCompressedBitmap32 iwah = IteratorUtil32.materialize(IteratorAggregation32.bufferedxor(IteratorUtil32.toIterators((EWAHCompressedBitmap32[])ewah)));
                if (!answer.equals(iwah)) {
                    throw new RuntimeException("bug xor it ");
                }
                long bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        LogicalElement ewahor4 = ewah[0];
                        for (int j = 1; j < k + 1; ++j) {
                            ewahor4 = ((EWAHCompressedBitmap32)ewahor4).xor((EWAHCompressedBitmap32)ewah[j]);
                        }
                    }
                }
                long aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap32[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        ewahor = (EWAHCompressedBitmap32)FastAggregation.xor((LogicalElement[])ewahcp);
                        bogus += (long)((EWAHCompressedBitmap32)ewahor).sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap32[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        ewahor = FastAggregation32.bufferedxor(65536, (EWAHCompressedBitmap32[])ewahcp);
                        bogus += (long)((EWAHCompressedBitmap32)ewahor).sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new IteratingRLW32[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = new IteratingBufferedRunningLengthWord32((EWAHCompressedBitmap32)ewah[j]);
                        }
                        ewahor = IteratorAggregation32.bufferedxor((IteratingRLW32[])ewahcp);
                        int wordcounter = IteratorUtil32.cardinality((IteratingRLW32)ewahor);
                        bogus += (long)wordcounter;
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                System.out.println("# times for: 2by2 FastAggregation.xor  bufferedxor iterator-based");
                System.out.println(line);
            }
            System.out.println("# bogus =" + bogus);
        }
    }
}

