/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class VersionListing {
    private final String latest;
    private final String release;
    private final List<String> available;
    private final LocalDateTime lastUpdated;

    public static VersionListing of(String string, String string2, List<String> list2, LocalDateTime localDateTime) {
        return new VersionListing(string, string2, list2, localDateTime);
    }

    private VersionListing(String string, String string2, List<String> list2, LocalDateTime localDateTime) {
        this.latest = string;
        this.release = string2;
        this.available = Collections.unmodifiableList(new ArrayList<String>(list2));
        this.lastUpdated = localDateTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof VersionListing) {
            VersionListing versionListing = (VersionListing)object;
            return this.latest.equals(versionListing.latest) && this.release.equals(versionListing.release) && this.available.equals(versionListing.available) && Objects.equals(this.lastUpdated, versionListing.lastUpdated);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (17 + this.latest.hashCode()) + this.release.hashCode()) + this.available.hashCode()) + Objects.hashCode(this.lastUpdated);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("VersionListing(");
        stringBuilder.append(this.latest);
        stringBuilder.append(", ");
        stringBuilder.append(this.release);
        stringBuilder.append(", available = List(");
        boolean bl = true;
        for (String string : this.available) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
        if (this.lastUpdated != null) {
            stringBuilder.append(", lastUpdated = ");
            stringBuilder.append(this.lastUpdated.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getLatest() {
        return this.latest;
    }

    public String getRelease() {
        return this.release;
    }

    public List<String> getAvailable() {
        return this.available;
    }

    public LocalDateTime getLastUpdated() {
        return this.lastUpdated;
    }
}

