/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Movement;
import pcgen.core.Race;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MoveToken
extends AbstractTokenWithSeparator<Race>
implements CDOMPrimaryToken<Race> {
    @Override
    public String getTokenName() {
        return "MOVE";
    }

    private ParseResult validateMove(String value, String mod) {
        try {
            if (Integer.parseInt(mod) < 0) {
                return new ParseResult.Fail("Invalid movement (cannot be negative): " + mod + " in MOVE: " + value);
            }
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Invalid movement (must be an integer >= 0): " + mod + " in MOVE: " + value);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    protected char separator() {
        return ',';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Race obj, String value) {
        Movement cm;
        StringTokenizer moves = new StringTokenizer(value, ",");
        if (moves.countTokens() == 1) {
            cm = new Movement(1);
            String mod = moves.nextToken();
            ParseResult pr = this.validateMove(value, mod);
            if (!pr.passed()) {
                return pr;
            }
            cm.assignMovement(0, "Walk", mod);
        } else {
            cm = new Movement(moves.countTokens() / 2);
            int x = 0;
            while (moves.countTokens() > 1) {
                String type = moves.nextToken();
                String mod = moves.nextToken();
                ParseResult pr = this.validateMove(value, mod);
                if (!pr.passed()) {
                    return pr;
                }
                cm.assignMovement(x++, type, mod);
            }
            if (moves.countTokens() != 0) {
                return new ParseResult.Fail("Badly formed MOVE token (extra value at end of list): " + value, context);
            }
        }
        cm.setMoveRatesFlag(0);
        context.getObjectContext().addToList(obj, ListKey.BASE_MOVEMENT, cm);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Race obj) {
        Changes<Movement> changes = context.getObjectContext().getListChanges(obj, ListKey.BASE_MOVEMENT);
        Collection<Movement> added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (Movement m : added) {
            if (m.getMoveRatesFlag() != 0) continue;
            StringBuilder sb = new StringBuilder();
            m.addTokenContents(sb);
            set.add(sb.toString());
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

