/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class XtrafeatsToken
implements CDOMPrimaryToken<PCClass> {
    @Override
    public String getTokenName() {
        return "XTRAFEATS";
    }

    @Override
    public ParseResult parseToken(LoadContext context, PCClass pcc, String value) {
        try {
            int featCount = Integer.parseInt(value);
            if (featCount == 0) {
                Logging.deprecationPrint(this.getTokenName() + " should not be used if zero (default is zero)", context);
            } else if (featCount <= 0) {
                return new ParseResult.Fail("Number in " + this.getTokenName() + " must be greater than zero: " + value, context);
            }
            context.getObjectContext().put((CDOMObject)pcc, IntegerKey.START_FEATS, featCount);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Invalid Number in " + this.getTokenName() + ": " + value, context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, PCClass obj) {
        Integer feats = context.getObjectContext().getInteger(obj, IntegerKey.START_FEATS);
        if (feats == null) {
            return null;
        }
        if (feats <= 0) {
            context.addWriteMessage(this.getTokenName() + " must be an integer > 0");
            return null;
        }
        return new String[]{feats.toString()};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

