/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.ability;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.kit.KitAbilities;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AbilityToken
extends AbstractNonEmptyToken<KitAbilities>
implements CDOMPrimaryToken<KitAbilities> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;
    private static final Class<AbilityCategory> ABILITY_CATEGORY_CLASS = AbilityCategory.class;

    @Override
    public String getTokenName() {
        return "ABILITY";
    }

    @Override
    public Class<KitAbilities> getTokenClass() {
        return KitAbilities.class;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, KitAbilities kitAbil, String value) {
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail("No pipe found.  ABILITY token in a Kit requires CATEGORY=<cat>|<ability>,<ability>", context);
        }
        String catString = value.substring(0, pipeLoc);
        if (!catString.startsWith("CATEGORY=")) {
            return new ParseResult.Fail("No CATEGORY= found.  ABILITY token in a Kit requires CATEGORY=<cat>|<abilities>", context);
        }
        if (catString.length() < 10) {
            return new ParseResult.Fail("No category found.  ABILITY token in a Kit requires CATEGORY=<cat>|<abilities>", context);
        }
        String acName = catString.substring(9);
        CDOMSingleRef<AbilityCategory> acRef = context.getReferenceContext().getCDOMReference(ABILITY_CATEGORY_CLASS, acName);
        kitAbil.setCategory(acRef);
        String rest = value.substring(pipeLoc + 1);
        if (this.isEmpty(rest) || this.hasIllegalSeparator('|', rest)) {
            return new ParseResult.Fail("No abilities found.  ABILITY token in a Kit requires CATEGORY=<cat>|<abilities>");
        }
        StringTokenizer st = new StringTokenizer(rest, "|");
        ReferenceManufacturer<Ability> rm = context.getReferenceContext().getManufacturer(ABILITY_CLASS, ABILITY_CATEGORY_CLASS, acName);
        if (rm == null) {
            return new ParseResult.Fail("Could not get Reference Manufacturer for Category: " + acName, context);
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("CATEGORY=")) {
                return new ParseResult.Fail("Attempting to change the Category to '" + token + "': " + value);
            }
            CDOMReference<Ability> ref = TokenUtilities.getTypeOrPrimitive(rm, token);
            if (ref == null) {
                return ParseResult.INTERNAL_ERROR;
            }
            kitAbil.addAbility(ref);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitAbilities kitAbil) {
        Collection<CDOMReference<Ability>> references = kitAbil.getAbilityKeys();
        if (references == null || references.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("CATEGORY=");
        result.append(kitAbil.getCategory().getLSTformat(false));
        for (CDOMReference<Ability> ref : references) {
            result.append("|");
            result.append(ref.getLSTformat(false));
        }
        return new String[]{result.toString()};
    }
}

