/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.StringTokenizer;
import pcgen.cdom.base.Loadable;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstUtils;
import pcgen.rules.context.LoadContext;

public class SimpleLoader<T extends Loadable>
extends LstLineFileLoader {
    private final Class<T> loadClass;

    public SimpleLoader(Class<T> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Loaded Class cannot be null");
        }
        this.loadClass = cl;
    }

    @Override
    public void parseLine(LoadContext context, String lstLine, URI sourceURI) throws PersistenceLayerException {
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        String firstToken = colToken.nextToken().trim();
        T loadable = this.getLoadable(context, firstToken.intern(), sourceURI);
        if (loadable == null) {
            return;
        }
        while (colToken.hasMoreTokens()) {
            LstUtils.processToken(context, loadable, sourceURI, colToken.nextToken());
        }
    }

    protected T getLoadable(LoadContext context, String firstToken, URI sourceURI) throws PersistenceLayerException {
        String name = this.processFirstToken(context, firstToken);
        if (name == null) {
            return null;
        }
        T loadable = context.getReferenceContext().constructCDOMObject(this.loadClass, name.intern());
        loadable.setSourceURI(sourceURI);
        return loadable;
    }

    protected String processFirstToken(LoadContext context, String token) {
        return token;
    }

    public Class<T> getLoadClass() {
        return this.loadClass;
    }
}

