/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.SystemCollections;
import pcgen.core.character.EquipSlot;
import pcgen.persistence.lst.EquipSlotLstToken;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class EquipSlotLoader
extends LstLineFileLoader {
    @Override
    public void parseLine(LoadContext context, String lstLine, URI sourceURI) {
        EquipSlot eqSlot = new EquipSlot();
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        Map<String, LstToken> tokenMap = TokenStore.inst().getTokenMap(EquipSlotLstToken.class);
        while (colToken.hasMoreTokens()) {
            String value;
            String colString = colToken.nextToken().trim();
            int idxColon = colString.indexOf(58);
            String key = "";
            try {
                key = colString.substring(0, idxColon);
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
            EquipSlotLstToken token = (EquipSlotLstToken)tokenMap.get(key);
            if (token != null && key.equals("NUMSLOTS")) {
                value = colString.substring(idxColon + 1);
                LstUtils.deprecationCheck(token, eqSlot.getSlotName(), sourceURI, value);
                if (token.parse(eqSlot, lstLine, this.getGameMode())) break;
                Logging.errorPrint("Error parsing equip slots " + eqSlot.getSlotName() + ':' + sourceURI + ':' + colString + "\"");
                break;
            }
            if (token != null) {
                value = colString.substring(idxColon + 1);
                LstUtils.deprecationCheck(token, eqSlot.getSlotName(), sourceURI, value);
                if (token.parse(eqSlot, value, this.getGameMode())) continue;
                Logging.errorPrint("Error parsing equip slots " + eqSlot.getSlotName() + ':' + sourceURI + ':' + colString + "\"");
                continue;
            }
            Logging.errorPrint("Illegal slot info '" + lstLine + "' in " + sourceURI.toString());
        }
        SystemCollections.addToEquipSlotsList(eqSlot, this.getGameMode());
    }
}

