/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.prereq.Prerequisite;
import pcgen.io.PCGFile;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class CampaignLoader
extends LstLineFileLoader {
    private Campaign campaign = null;
    private final List<Campaign> inittedCampaigns = new ArrayList<Campaign>();
    public static final ListKey[] OTHER_FILE_LISTKEY = new ListKey[]{ListKey.FILE_LST_EXCLUDE, ListKey.FILE_COVER};
    public static final ListKey[] OBJECT_FILE_LISTKEY = new ListKey[]{ListKey.FILE_RACE, ListKey.FILE_CLASS, ListKey.FILE_COMPANION_MOD, ListKey.FILE_SKILL, ListKey.FILE_ABILITY_CATEGORY, ListKey.FILE_ABILITY, ListKey.FILE_FEAT, ListKey.FILE_DEITY, ListKey.FILE_DOMAIN, ListKey.FILE_ARMOR_PROF, ListKey.FILE_SHIELD_PROF, ListKey.FILE_WEAPON_PROF, ListKey.FILE_EQUIP, ListKey.FILE_SPELL, ListKey.FILE_LANGUAGE, ListKey.FILE_TEMPLATE, ListKey.FILE_EQUIP_MOD, ListKey.FILE_KIT, ListKey.FILE_BIO_SET, ListKey.FILE_ALIGNMENT, ListKey.FILE_STAT, ListKey.FILE_SAVE, ListKey.FILE_DATACTRL};

    public void initRecursivePccFiles(Campaign baseCampaign) {
        if (baseCampaign == null || this.inittedCampaigns.contains(baseCampaign)) {
            return;
        }
        this.inittedCampaigns.add(baseCampaign);
        for (CampaignSourceEntry cse : baseCampaign.getSafeListFor(ListKey.FILE_PCC)) {
            URI fName = cse.getURI();
            if (!PCGFile.isPCGenCampaignFile(fName)) continue;
            Campaign globalSubCampaign = Globals.getCampaignByURI(fName, false);
            if (globalSubCampaign == null) {
                try {
                    this.loadCampaignLstFile(fName);
                    globalSubCampaign = Globals.getCampaignByURI(fName, false);
                }
                catch (PersistenceLayerException e) {
                    Logging.errorPrint("Recursive init failed on file " + fName, e);
                }
            }
            this.initRecursivePccFiles(globalSubCampaign);
            this.initRecursivePccFiles(baseCampaign, globalSubCampaign);
        }
    }

    private void initRecursivePccFiles(Campaign baseCampaign, Campaign subCampaign) {
        if (subCampaign == null) {
            return;
        }
        for (ListKey lk : OBJECT_FILE_LISTKEY) {
            this.addToBaseCampaign(baseCampaign, subCampaign, lk);
        }
        for (ListKey lk : OTHER_FILE_LISTKEY) {
            this.addToBaseCampaign(baseCampaign, subCampaign, lk);
        }
    }

    private <T> void addToBaseCampaign(Campaign baseCampaign, Campaign subCampaign, ListKey<T> lk) {
        baseCampaign.addAllToListFor(lk, subCampaign.getSafeListFor(lk));
    }

    public void loadCampaignLstFile(URI filePath) throws PersistenceLayerException {
        this.campaign = new Campaign();
        this.campaign.setSourceURI(filePath);
        super.loadLstFile(this.campaign.getCampaignContext(), filePath);
        if (Globals.getCampaignByURI(this.campaign.getSourceURI(), false) == null) {
            this.validatePrereqs(this.campaign.getPrerequisiteList());
            List<String> copyright = this.campaign.getListFor(ListKey.SECTION_15);
            if (copyright != null) {
                StringBuilder sec15 = Globals.getSection15();
                sec15.append("<br><b>Source Material:</b>");
                sec15.append(SourceFormat.getFormattedString(this.campaign, SourceFormat.LONG, true));
                sec15.append("<br>");
                sec15.append("<b>Section 15 Entry in Source Material:</b><br>");
                for (String license : copyright) {
                    sec15.append(license).append("<br>");
                }
            }
            Globals.addCampaign(this.campaign);
        }
    }

    @Override
    public void parseLine(LoadContext context, String inputLine, URI sourceURI) throws PersistenceLayerException {
        LstUtils.processToken(context, this.campaign, sourceURI, inputLine);
    }

    private void validatePrereqs(List<Prerequisite> prereqList) {
        if (prereqList == null || prereqList.isEmpty()) {
            return;
        }
        for (Prerequisite prereq : prereqList) {
            if (prereq.isCharacterRequired()) {
                PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
                ArrayList<Prerequisite> displayList = new ArrayList<Prerequisite>();
                displayList.add(prereq);
                String lstString = prereqWriter.getPrerequisiteString(displayList, "\t");
                Logging.log(Logging.LST_ERROR, "Prereq " + prereq.getKind() + " is not supported in PCC files. Prereq was " + lstString + " in " + this.campaign.getSourceURI() + ". Prereq will be ignored.");
                continue;
            }
            this.validatePrereqs(prereq.getPrerequisites());
        }
    }
}

