/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.util.JTableEx;
import pcgen.gui2.util.SortingPriority;

public class JTableSortingHeader
extends JTableHeader
implements MouseListener {
    private static final long serialVersionUID = -2459707147524421794L;
    private static final Icon ASCENDING_ICON = Icons.Down16.getImageIcon();
    private static final Icon DESCENDING_ICON = Icons.Up16.getImageIcon();
    private static final ButtonModel defaultModel = new DefaultButtonModel();
    private final ButtonModel usedModel = new DefaultButtonModel();

    public JTableSortingHeader(JTableEx table) {
        super(table.getColumnModel());
        this.table = table;
        this.addMouseListener(this);
    }

    @Override
    protected TableCellRenderer createDefaultRenderer() {
        return new SortingHeaderRenderer();
    }

    @Override
    public JTableEx getTable() {
        return (JTableEx)super.getTable();
    }

    public TableColumn getTrackedColumn() {
        TableColumnModel model = this.getColumnModel();
        Point mousepos = this.getMousePosition();
        if (mousepos != null) {
            return model.getColumn(model.getColumnIndexAtX(mousepos.x));
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.getCursor() == Cursor.getDefaultCursor() && this.getTrackedColumn() != null) {
            this.getTable().toggleSort(this.getTrackedColumn().getModelIndex());
            this.usedModel.setPressed(false);
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.usedModel.setPressed(true);
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.usedModel.setPressed(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.usedModel.setRollover(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.usedModel.setRollover(false);
    }

    public class SortingHeaderRenderer
    extends JButton
    implements TableCellRenderer {
        public SortingHeaderRenderer() {
            this.setHorizontalTextPosition(10);
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SortingPriority order;
            TableColumn dragColumn = JTableSortingHeader.this.getDraggedColumn();
            if (dragColumn != null && dragColumn.getHeaderValue() == value) {
                this.setModel(JTableSortingHeader.this.usedModel);
            } else {
                this.setModel(defaultModel);
            }
            Icon icon = null;
            int modelIndex = jTable.convertColumnIndexToModel(column);
            List<SortingPriority> list = JTableSortingHeader.this.getTable().getSortingPriority();
            if (!list.isEmpty() && (order = list.get(0)).getColumn() == modelIndex) {
                switch (order.getMode()) {
                    case ASCENDING: {
                        icon = ASCENDING_ICON;
                        break;
                    }
                    case DESCENDING: {
                        icon = DESCENDING_ICON;
                    }
                }
            }
            this.setIcon(icon);
            this.setText(value.toString());
            return this;
        }
    }
}

