/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.spells;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.SpellFacade;
import pcgen.facade.core.SpellSupportFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilterUtilities;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.spells.ClassInfoHandler;
import pcgen.gui2.tabs.spells.QualifiedSpellTreeCellRenderer;
import pcgen.gui2.tabs.spells.SpellInfoHandler;
import pcgen.gui2.tabs.spells.SpellTreeViewModel;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.JTreeViewTable;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class SpellsPreparedTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private final TabTitle tabTitle = new TabTitle(Tab.PREPARED_SPELLS);
    private final FilteredTreeViewTable<CharacterFacade, SpellSupportFacade.SuperNode> availableTable = new FilteredTreeViewTable();
    private final JTreeViewTable<SpellSupportFacade.SuperNode> selectedTable = new JTreeViewTable();
    private final QualifiedSpellTreeCellRenderer spellRenderer = new QualifiedSpellTreeCellRenderer();
    private final JButton addMMSpellButton = new JButton();
    private final JButton addSpellButton = new JButton();
    private final JButton removeSpellButton = new JButton();
    private final FilterButton<CharacterFacade, SpellSupportFacade.SuperNode> qFilterButton = new FilterButton("SpellPreparedQualified");
    private final JButton addSpellListButton = new JButton();
    private final JButton removeSpellListButton = new JButton();
    private final JCheckBox slotsBox = new JCheckBox();
    private final JTextField spellListField = new JTextField();
    private final InfoPane spellsPane = new InfoPane(LanguageBundle.getString("InfoSpells.spell.info"));
    private final InfoPane classPane = new InfoPane(LanguageBundle.getString("InfoSpells.class.info"));

    public SpellsPreparedTab() {
        super("SpellsPrepared");
        this.initComponents();
    }

    private void initComponents() {
        this.availableTable.setTreeCellRenderer(this.spellRenderer);
        this.selectedTable.setTreeCellRenderer(this.spellRenderer);
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.qFilterButton.setText(LanguageBundle.getString("in_igQualFilter"));
        filterBar.addDisplayableFilter(this.qFilterButton);
        FlippingSplitPane upperPane = new FlippingSplitPane("SpellsPreparedTop");
        JPanel availPanel = FilterUtilities.configureFilteredTreeViewPane(this.availableTable, filterBar);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(5));
        Box hbox = Box.createHorizontalBox();
        this.addMMSpellButton.setHorizontalTextPosition(10);
        hbox.add(this.addMMSpellButton);
        box.add(hbox);
        box.add(Box.createVerticalStrut(2));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.slotsBox);
        hbox.add(Box.createHorizontalGlue());
        hbox.add(Box.createHorizontalStrut(10));
        hbox.add(this.addSpellButton);
        hbox.add(Box.createHorizontalStrut(5));
        box.add(hbox);
        box.add(Box.createVerticalStrut(5));
        availPanel.add((Component)box, "South");
        upperPane.setLeftComponent(availPanel);
        box = Box.createVerticalBox();
        box.add(new JScrollPane(this.selectedTable));
        box.add(Box.createVerticalStrut(4));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.removeSpellButton);
        hbox.add(Box.createHorizontalStrut(10));
        hbox.add(new JLabel(LanguageBundle.getString("InfoPreparedSpells.preparedList")));
        hbox.add(Box.createHorizontalStrut(3));
        hbox.add(this.spellListField);
        hbox.add(Box.createHorizontalStrut(3));
        hbox.add(this.addSpellListButton);
        hbox.add(Box.createHorizontalStrut(3));
        hbox.add(this.removeSpellListButton);
        hbox.add(Box.createHorizontalStrut(5));
        box.add(hbox);
        box.add(Box.createVerticalStrut(5));
        upperPane.setRightComponent(box);
        upperPane.setResizeWeight(0.0);
        this.setTopComponent(upperPane);
        FlippingSplitPane bottomPane = new FlippingSplitPane("SpellsPreparedBottom");
        bottomPane.setLeftComponent(this.spellsPane);
        bottomPane.setRightComponent(this.classPane);
        this.setBottomComponent(bottomPane);
        this.setOrientation(0);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(TreeViewModelHandler.class, new TreeViewModelHandler(character));
        models.put(AddMMSpellAction.class, new AddMMSpellAction(character));
        models.put(AddSpellAction.class, new AddSpellAction(character));
        models.put(RemoveSpellAction.class, new RemoveSpellAction(character));
        models.put(AddSpellListAction.class, new AddSpellListAction(character));
        models.put(RemoveSpellListAction.class, new RemoveSpellListAction(character));
        models.put(UseHigherSlotsAction.class, new UseHigherSlotsAction(character));
        models.put(SpellInfoHandler.class, new SpellInfoHandler(character, this.availableTable, this.selectedTable, this.spellsPane));
        models.put(ClassInfoHandler.class, new ClassInfoHandler(character, this.availableTable, this.selectedTable, this.classPane));
        models.put(SpellFilterHandler.class, new SpellFilterHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(SpellFilterHandler.class).install();
        models.get(TreeViewModelHandler.class).install();
        models.get(SpellInfoHandler.class).install();
        models.get(ClassInfoHandler.class).install();
        models.get(AddSpellAction.class).install();
        models.get(RemoveSpellAction.class).install();
        this.addMMSpellButton.setAction(models.get(AddMMSpellAction.class));
        this.addSpellListButton.setAction(models.get(AddSpellListAction.class));
        this.removeSpellListButton.setAction(models.get(RemoveSpellListAction.class));
        models.get(UseHigherSlotsAction.class).install();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(SpellInfoHandler.class).uninstall();
        models.get(ClassInfoHandler.class).uninstall();
        models.get(AddSpellAction.class).uninstall();
        models.get(RemoveSpellAction.class).uninstall();
        models.get(TreeViewModelHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    String getCurrentSpellListName(CharacterFacade character) {
        Object firstElem;
        ListFacade<?> data;
        String spellList = "";
        Object selectedObject = this.selectedTable.getSelectedObject();
        if (selectedObject != null) {
            if (selectedObject instanceof SpellSupportFacade.SpellNode) {
                spellList = ((SpellSupportFacade.SpellNode)selectedObject).getRootNode().toString();
            } else {
                JTree tree = this.selectedTable.getTree();
                TreePath path = tree.getSelectionPath();
                while (path.getParentPath() != null && path.getParentPath().getParentPath() != null) {
                    path = path.getParentPath();
                }
                spellList = path.getLastPathComponent().toString();
            }
        }
        if (StringUtils.isEmpty(spellList)) {
            spellList = this.spellListField.getText();
        }
        if (StringUtils.isEmpty(spellList) && !(data = this.selectedTable.getTreeViewModel().getDataModel()).isEmpty() && (firstElem = data.getElementAt(0)) instanceof SpellSupportFacade.SpellNode) {
            spellList = ((SpellSupportFacade.SpellNode)firstElem).getRootNode().toString();
        }
        if (StringUtils.isEmpty(spellList)) {
            spellList = "Prepared Spells";
            character.getSpellSupport().addSpellList(spellList);
        }
        return spellList;
    }

    private class SpellFilterHandler
    implements Filter<CharacterFacade, SpellSupportFacade.SuperNode> {
        private final CharacterFacade character;

        public SpellFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            SpellsPreparedTab.this.qFilterButton.setFilter(this);
        }

        @Override
        public boolean accept(CharacterFacade context, SpellSupportFacade.SuperNode element) {
            if (element instanceof SpellSupportFacade.SpellNode) {
                SpellSupportFacade.SpellNode spellNode = (SpellSupportFacade.SpellNode)element;
                SpellFacade spell = spellNode.getSpell();
                ClassFacade pcClass = spellNode.getSpellcastingClass();
                return this.character.isQualifiedFor(spell, pcClass);
            }
            return true;
        }
    }

    private class TreeViewModelHandler {
        private SpellTreeViewModel availableModel;
        private SpellTreeViewModel selectedModel;
        private CharacterFacade character;

        public TreeViewModelHandler(CharacterFacade character) {
            this.character = character;
            this.availableModel = new SpellTreeViewModel(character.getSpellSupport().getKnownSpellNodes(), false, "SpellsPrepAva", character.getInfoFactory());
            this.selectedModel = new SpellTreeViewModel(character.getSpellSupport().getPreparedSpellNodes(), true, "SpellsPrepSel", character.getInfoFactory());
        }

        public void install() {
            SpellsPreparedTab.this.spellRenderer.setCharacter(this.character);
            SpellsPreparedTab.this.availableTable.setTreeViewModel(this.availableModel);
            SpellsPreparedTab.this.selectedTable.setTreeViewModel(this.selectedModel);
        }

        public void uninstall() {
            SpellsPreparedTab.this.spellRenderer.setCharacter(null);
        }
    }

    private class RemoveSpellListAction
    extends AbstractAction {
        private CharacterFacade character;

        public RemoveSpellListAction(CharacterFacade character) {
            super(LanguageBundle.getString("InfoSpells.delete"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.getSpellSupport().removeSpellList(SpellsPreparedTab.this.spellListField.getText());
        }
    }

    private class AddSpellListAction
    extends AbstractAction {
        private CharacterFacade character;

        public AddSpellListAction(CharacterFacade character) {
            super(LanguageBundle.getString("InfoSpells.add"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.getSpellSupport().addSpellList(SpellsPreparedTab.this.spellListField.getText());
        }
    }

    private class UseHigherSlotsAction
    extends AbstractAction {
        private CharacterFacade character;

        public UseHigherSlotsAction(CharacterFacade character) {
            super(LanguageBundle.getString("InfoPreparedSpells.canUseHigherSlots"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.getSpellSupport().setUseHigherPreppedSlots(SpellsPreparedTab.this.slotsBox.isSelected());
        }

        public void install() {
            SpellsPreparedTab.this.slotsBox.setAction(this);
            SpellsPreparedTab.this.slotsBox.setSelected(this.character.getSpellSupport().isUseHigherPreppedSlots());
        }
    }

    private class RemoveSpellAction
    extends AbstractAction {
        private CharacterFacade character;

        public RemoveSpellAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = SpellsPreparedTab.this.selectedTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof SpellSupportFacade.SpellNode)) continue;
                SpellSupportFacade.SpellNode spellNode = (SpellSupportFacade.SpellNode)object;
                this.character.getSpellSupport().removePreparedSpell(spellNode, spellNode.getRootNode().toString());
            }
        }

        public void install() {
            SpellsPreparedTab.this.selectedTable.addActionListener(this);
            SpellsPreparedTab.this.removeSpellButton.setAction(this);
        }

        public void uninstall() {
            SpellsPreparedTab.this.selectedTable.removeActionListener(this);
        }
    }

    private class AddSpellAction
    extends AbstractAction {
        private CharacterFacade character;

        public AddSpellAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = SpellsPreparedTab.this.availableTable.getSelectedData();
            String spellList = SpellsPreparedTab.this.getCurrentSpellListName(this.character);
            for (Object object : data) {
                if (!(object instanceof SpellSupportFacade.SpellNode)) continue;
                this.character.getSpellSupport().addPreparedSpell((SpellSupportFacade.SpellNode)object, spellList, false);
            }
        }

        public void install() {
            SpellsPreparedTab.this.availableTable.addActionListener(this);
            SpellsPreparedTab.this.addSpellButton.setAction(this);
        }

        public void uninstall() {
            SpellsPreparedTab.this.availableTable.removeActionListener(this);
        }
    }

    private class AddMMSpellAction
    extends AbstractAction {
        private CharacterFacade character;

        public AddMMSpellAction(CharacterFacade character) {
            this.character = character;
            String label = character.getDataSet().getGameMode().getAddWithMetamagicMessage();
            if (StringUtils.isEmpty(label)) {
                label = LanguageBundle.getString("InfoSpells.add.with.metamagic");
            }
            this.putValue("Name", label);
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = SpellsPreparedTab.this.availableTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof SpellSupportFacade.SpellNode)) continue;
                String spellList = SpellsPreparedTab.this.getCurrentSpellListName(this.character);
                this.character.getSpellSupport().addPreparedSpell((SpellSupportFacade.SpellNode)object, spellList, true);
            }
        }
    }
}

