/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.PCClass;
import pcgen.core.spell.Spell;

public class KitSpellBookEntry {
    private final String bookName;
    private final Spell spell;
    private final int theCount;
    private final List<CDOMSingleRef<Ability>> theModifierList;
    private PCClass theClass = null;

    public KitSpellBookEntry(String aBookName, Spell sp, List<CDOMSingleRef<Ability>> modifiers, int copies) {
        this.bookName = aBookName;
        this.spell = sp;
        if (modifiers != null && modifiers.size() > 0) {
            this.theModifierList = new ArrayList<CDOMSingleRef<Ability>>();
            this.theModifierList.addAll(modifiers);
        } else {
            this.theModifierList = null;
        }
        this.theCount = copies;
    }

    public String getBookName() {
        return this.bookName;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public List<CDOMSingleRef<Ability>> getModifiers() {
        List<CDOMSingleRef<Ability>> ret = this.theModifierList;
        if (ret == null) {
            ret = new ArrayList<CDOMSingleRef<Ability>>();
        }
        return Collections.unmodifiableList(ret);
    }

    public int getCopies() {
        return this.theCount;
    }

    public void setPCClass(PCClass aClass) {
        this.theClass = aClass;
    }

    public PCClass getPCClass() {
        return this.theClass;
    }

    public String toString() {
        return this.spell.getDisplayName();
    }
}

