/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.WeaponProf;
import pcgen.core.kit.BaseKit;

public final class KitProf
extends BaseKit {
    private Integer choiceCount;
    private final List<CDOMSingleRef<WeaponProf>> profList = new ArrayList<CDOMSingleRef<WeaponProf>>();
    private Boolean racialProf;
    private transient CDOMObject thePObject = null;
    private transient List<WeaponProf> weaponProfs = null;

    public boolean isRacial() {
        return this.racialProf != null && this.racialProf != false;
    }

    public void setRacialProf(Boolean argRacial) {
        this.racialProf = argRacial;
    }

    public String toString() {
        int maxSize = this.profList.size();
        StringBuilder info = new StringBuilder(maxSize * 10);
        if (this.getSafeCount() != 1 || maxSize != 1) {
            info.append(this.getSafeCount()).append(" of ");
        }
        info.append(StringUtil.join(this.profList, (String)", "));
        return info.toString();
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        List xs;
        this.thePObject = null;
        this.weaponProfs = null;
        PersistentTransitionChoice<WeaponProf> wpPTC = null;
        if (this.isRacial()) {
            Race pcRace = aPC.getRace();
            if (pcRace == null) {
                warnings.add("PROF: PC has no race");
                return false;
            }
            if (!aPC.hasBonusWeaponProfs(pcRace)) {
                warnings.add("PROF: Race has already selected bonus weapon proficiency");
                return false;
            }
            this.thePObject = pcRace;
            wpPTC = this.getPTC(pcRace);
            if (wpPTC == null) {
                warnings.add("PROF: PC race has no WEAPONBONUS");
                return false;
            }
        } else {
            Set<PCClass> pcClasses = aPC.getClassSet();
            if (pcClasses == null || pcClasses.size() == 0) {
                warnings.add("PROF: No owning class found.");
                return false;
            }
            PCClass pcClass = null;
            Iterator i = pcClasses.iterator();
            while (i.hasNext() && (wpPTC = this.getPTC(pcClass = (PCClass)i.next())) == null) {
            }
            if (wpPTC == null) {
                warnings.add("PROF: PC classes have no WEAPONBONUS");
                return false;
            }
            this.thePObject = pcClass;
            if (!aPC.hasBonusWeaponProfs(pcClass)) {
                warnings.add("PROF: Class has already selected bonus weapon proficiency");
                return false;
            }
        }
        ArrayList aProfList = new ArrayList();
        Collection choices = wpPTC.getChoices().getSet(aPC);
        for (CDOMSingleRef<WeaponProf> profKey : this.profList) {
            WeaponProf wp = profKey.resolvesTo();
            if (choices.contains(wp)) {
                wpPTC.act(Collections.singleton(wp), this.thePObject, aPC);
                continue;
            }
            warnings.add("PROF: Weapon proficiency \"" + wp.getKeyName() + "\" is not in list of choices");
        }
        int numberOfChoices = this.getSafeCount();
        if (numberOfChoices > aProfList.size()) {
            numberOfChoices = aProfList.size();
        }
        if (numberOfChoices == 0) {
            return false;
        }
        if (numberOfChoices == aProfList.size()) {
            xs = aProfList;
        } else {
            while ((xs = Globals.getChoiceFromList("Choose Proficiencies", aProfList, new ArrayList(), numberOfChoices, aPC)).size() == 0) {
            }
        }
        for (WeaponProf prof : xs) {
            if (this.weaponProfs == null) {
                this.weaponProfs = new ArrayList<WeaponProf>();
            }
            this.weaponProfs.add(prof);
        }
        return false;
    }

    private PersistentTransitionChoice<WeaponProf> getPTC(CDOMObject cdo) {
        List<PersistentTransitionChoice<?>> adds = cdo.getListFor(ListKey.ADD);
        for (PersistentTransitionChoice<WeaponProf> persistentTransitionChoice : adds) {
            if (!persistentTransitionChoice.getChoiceClass().equals(WeaponProf.class)) continue;
            return persistentTransitionChoice;
        }
        return null;
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        PersistentTransitionChoice<WeaponProf> wpPTC = this.getPTC(this.thePObject);
        Collection choices = wpPTC.getChoices().getSet(aPC);
        for (CDOMSingleRef<WeaponProf> profKey : this.profList) {
            WeaponProf wp = profKey.resolvesTo();
            if (!choices.contains(wp)) continue;
            wpPTC.act(Collections.singleton(wp), this.thePObject, aPC);
        }
    }

    @Override
    public String getObjectName() {
        return "Proficiencies";
    }

    public void setCount(Integer quan) {
        this.choiceCount = quan;
    }

    public Integer getCount() {
        return this.choiceCount;
    }

    public int getSafeCount() {
        return this.choiceCount == null ? 1 : this.choiceCount;
    }

    public void addProficiency(CDOMSingleRef<WeaponProf> ref) {
        this.profList.add(ref);
    }

    public Collection<CDOMSingleRef<WeaponProf>> getProficiencies() {
        return this.profList;
    }

    public Boolean getRacialProf() {
        return this.racialProf;
    }
}

