/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pcgen.cdom.enumeration.Type;
import pcgen.core.character.EquipSlot;
import pcgen.facade.core.BodyStructureFacade;

public class BodyStructure
implements BodyStructureFacade {
    private String name;
    private List<EquipSlot> slots;
    private boolean holdsAnyType;
    private Set<Type> forbiddenTypes;

    public BodyStructure(String name) {
        this(name, false);
    }

    public BodyStructure(String name, boolean holdsAnyType) {
        this(name, holdsAnyType, null);
    }

    public BodyStructure(String name, boolean holdsAnyType, Set<Type> forbiddenTypes) {
        this.name = name;
        this.forbiddenTypes = new HashSet<Type>();
        if (forbiddenTypes != null) {
            this.forbiddenTypes.addAll(forbiddenTypes);
        }
        this.slots = new ArrayList<EquipSlot>();
        this.holdsAnyType = holdsAnyType;
    }

    String getName() {
        return this.name;
    }

    public void addEquipSlot(EquipSlot slot) {
        if (!this.slots.contains(slot)) {
            this.slots.add(slot);
        }
    }

    public List<EquipSlot> getEquipSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    public String toString() {
        return this.name;
    }

    public boolean isHoldsAnyType() {
        return this.holdsAnyType;
    }

    public boolean isForbidden(Collection<Type> types) {
        for (Type type : types) {
            if (!this.forbiddenTypes.contains(type)) continue;
            return true;
        }
        return false;
    }
}

