/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import pcgen.cdom.base.Categorized;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CDOMTransparentAllRef;
import pcgen.cdom.reference.CDOMTransparentCategorizedSingleRef;
import pcgen.cdom.reference.CDOMTransparentTypeRef;
import pcgen.cdom.reference.ManufacturableFactory;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedValidator;

public class TransparentCategorizedFactory<T extends Categorized<T>>
implements ManufacturableFactory<T> {
    private final Class<T> refClass;
    private final String category;

    public TransparentCategorizedFactory(Class<T> objClass, String categoryName) {
        if (objClass == null) {
            throw new IllegalArgumentException("Reference Class for " + this.getClass().getName() + " cannot be null");
        }
        try {
            objClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class for " + this.getClass().getName() + " must possess a zero-argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class for " + this.getClass().getName() + " must possess a public zero-argument constructor", e);
        }
        this.refClass = objClass;
        this.category = categoryName;
    }

    @Override
    public CDOMGroupRef<T> getAllReference() {
        return new CDOMTransparentAllRef<T>(this.refClass);
    }

    @Override
    public CDOMGroupRef<T> getTypeReference(String ... types) {
        return new CDOMTransparentTypeRef<T>(this.refClass, types);
    }

    @Override
    public CDOMSingleRef<T> getReference(String key) {
        return new CDOMTransparentCategorizedSingleRef<T>(this.refClass, this.category, key);
    }

    @Override
    public T newInstance() {
        throw new UnsupportedOperationException("Cannot construct a new object");
    }

    @Override
    public boolean isMember(T item) {
        return this.refClass.equals(item.getClass());
    }

    @Override
    public Class<T> getReferenceClass() {
        return this.refClass;
    }

    @Override
    public String getReferenceDescription() {
        return this.getReferenceClass().getSimpleName() + " " + this.category;
    }

    @Override
    public boolean resolve(ReferenceManufacturer<T> rm, String name, CDOMSingleRef<T> value, UnconstructedValidator validator) {
        throw new UnsupportedOperationException("Resolution should not occur on Transparent object");
    }

    @Override
    public boolean populate(ReferenceManufacturer<T> parentCrm, ReferenceManufacturer<T> rm, UnconstructedValidator validator) {
        return true;
    }

    @Override
    public ManufacturableFactory<T> getParent() {
        throw new UnsupportedOperationException("Resolution of Parent should not occur on Transparent object");
    }
}

