/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.TreeMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.DamageReduction;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.PrerequisiteFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;

public class DamageReductionFacet
extends AbstractSourcedListFacet<CharID, DamageReduction>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private static final Pattern OR_PATTERN = Pattern.compile(" [oO][rR] ");
    private static final Pattern AND_PATTERN = Pattern.compile(" [aA][nN][dD] ");
    private PrerequisiteFacet prerequisiteFacet;
    private FormulaResolvingFacet formulaResolvingFacet;
    private BonusCheckingFacet bonusCheckingFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<DamageReduction> drs = cdo.getListFor(ListKey.DAMAGE_REDUCTION);
        if (drs != null) {
            this.addAll(dfce.getCharID(), drs, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    private CaseInsensitiveMap<Integer> getDRMap(CharID id, Map<DamageReduction, Set<Object>> componentMap) {
        CaseInsensitiveMap andMap = new CaseInsensitiveMap();
        if (componentMap == null || componentMap.isEmpty()) {
            return andMap;
        }
        CaseInsensitiveMap orMap = new CaseInsensitiveMap();
        for (Map.Entry<DamageReduction, Set<Object>> me : componentMap.entrySet()) {
            DamageReduction dr = me.getKey();
            for (Object source : me.getValue()) {
                if (!this.prerequisiteFacet.qualifies(id, dr, source)) continue;
                String sourceString = source instanceof CDOMObject ? ((CDOMObject)source).getQualifiedKey() : "";
                int rawDrValue = this.formulaResolvingFacet.resolve(id, dr.getReduction(), sourceString).intValue();
                String bypass = dr.getBypass();
                if (OR_PATTERN.matcher(bypass).find()) {
                    Integer current = (Integer)orMap.get((Object)bypass);
                    if (current != null && current >= rawDrValue) continue;
                    orMap.put((Object)dr.getBypass(), (Object)rawDrValue);
                    continue;
                }
                String[] splits = AND_PATTERN.split(bypass);
                if (splits.length == 1) {
                    Integer current = (Integer)andMap.get((Object)dr.getBypass());
                    if (current != null && current >= rawDrValue) continue;
                    andMap.put((Object)dr.getBypass(), (Object)rawDrValue);
                    continue;
                }
                for (int j = 0; j < splits.length; ++j) {
                    Integer current = (Integer)andMap.get((Object)splits[j]);
                    if (current != null && current >= rawDrValue) continue;
                    andMap.put((Object)splits[j], (Object)rawDrValue);
                }
            }
        }
        for (Map.Entry<DamageReduction, Set<Object>> me : orMap.entrySet()) {
            String origBypass = ((Object)me.getKey()).toString();
            Integer reduction = (Integer)((Object)me.getValue());
            String[] orValues = OR_PATTERN.split(origBypass);
            boolean shouldAdd = true;
            for (int j = 0; j < orValues.length; ++j) {
                Integer andDR = (Integer)andMap.get((Object)orValues[j]);
                if (andDR == null || andDR < reduction) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            andMap.put((Object)origBypass, (Object)reduction);
        }
        return andMap;
    }

    public String getDRString(CharID id) {
        return this.getDRString(id, this.getCachedMap(id));
    }

    public String getDRString(CharID id, Map<DamageReduction, Set<Object>> cachedMap) {
        CaseInsensitiveMap<Integer> map = this.getDRMap(id, cachedMap);
        TreeMapToList hml = new TreeMapToList();
        for (Map.Entry me : map.entrySet()) {
            String key = me.getKey().toString();
            int value = (Integer)me.getValue();
            hml.addToListFor((Object)(value += (int)this.bonusCheckingFacet.getBonus(id, "DR", key)), (Object)key);
        }
        for (Integer reduction : hml.getKeySet()) {
            if (hml.sizeOfListFor((Object)reduction) <= 1) continue;
            TreeSet<String> set = new TreeSet<String>();
            for (String s : hml.getListFor((Object)reduction)) {
                if (OR_PATTERN.matcher(s).find()) continue;
                hml.removeFromListFor((Object)reduction, (Object)s);
                set.add(s);
            }
            hml.addToListFor((Object)reduction, (Object)StringUtil.join(set, (String)" and "));
        }
        StringBuilder sb = new StringBuilder(40);
        boolean needSeparator = false;
        for (Integer reduction : hml.getKeySet()) {
            TreeSet<String> set = new TreeSet<String>();
            for (String s : hml.getListFor((Object)reduction)) {
                set.add(reduction + "/" + s);
            }
            if (needSeparator) {
                sb.insert(0, "; ");
            }
            needSeparator = true;
            sb.insert(0, StringUtil.join(set, (String)"; "));
        }
        return sb.toString();
    }

    public Integer getDR(CharID id, String key) {
        return this.getNonBonusDR(id, key) + (int)this.bonusCheckingFacet.getBonus(id, "DR", key);
    }

    private int getNonBonusDR(CharID id, String key) {
        Integer drValue = (Integer)this.getDRMap(id, this.getCachedMap(id)).get((Object)key);
        return drValue == null ? 0 : drValue;
    }

    public void setPrerequisiteFacet(PrerequisiteFacet prerequisiteFacet) {
        this.prerequisiteFacet = prerequisiteFacet;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

