/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.formula;

import pcgen.base.formula.ReferenceFormula;

public class MultiplyingFormula
implements ReferenceFormula<Integer> {
    private final int multiplier;

    public MultiplyingFormula(int mult) {
        this.multiplier = mult;
    }

    @Override
    public Integer resolve(Number ... numbers) {
        if (numbers == null || numbers.length != 1) {
            throw new IllegalArgumentException("MultiplyingFormula only has one backreference");
        }
        double d = numbers[0].doubleValue() * (double)this.multiplier;
        return (int)d;
    }

    public String toString() {
        return "*" + this.multiplier;
    }

    public int hashCode() {
        return this.multiplier;
    }

    public boolean equals(Object obj) {
        return obj instanceof MultiplyingFormula && ((MultiplyingFormula)obj).multiplier == this.multiplier;
    }
}

