/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.chart.BarChart;
import com.jgoodies.chart.ChartView;
import com.jgoodies.chart.PieChart;
import com.jgoodies.chart.SunburstChart;
import com.jgoodies.chart.TreeMapChart;
import com.jgoodies.common.jsdl.i18n.Resources;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.components.JGCardPanel;
import com.jgoodies.components.JGStripedTable;
import com.jgoodies.components.JGTable;
import com.jgoodies.framework.table.TableBuilder;
import com.jgoodies.framework.table.TableColumns;
import com.jgoodies.jdiskreport.gui.application.JDPresentationModel;
import com.jgoodies.jdiskreport.gui.application.JDResources;
import com.jgoodies.jdiskreport.gui.application.JDResultModel;
import com.jgoodies.jdiskreport.gui.application.JDViewModeResources;
import com.jgoodies.jdiskreport.gui.node.AbstractNode;
import com.jgoodies.jdiskreport.gui.settings.GUISettings;
import com.jgoodies.jdiskreport.gui.shared.component.ScrollPaneBorder;
import com.jgoodies.jdiskreport.gui.shared.format.JDFormats;
import com.jgoodies.jdiskreport.gui.shared.renderer.JDRenderers;
import com.jgoodies.layout.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.text.Format;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public final class JDPresentationView {
    private static final ResourceMap RESOURCES = Application.getResourceMap(JDPresentationView.class);
    private static JDViewModeResources res = Resources.get(JDViewModeResources.class);
    private final JDResultModel resultModel;
    private final JDPresentationModel presentationModel;
    private JGCardPanel cardPanel;
    private PieChart<AbstractNode> overviewSizePieChart;
    private BarChart<Object> overviewSizeDistributionBarChart;
    private BarChart<Object> overviewTimeDistributionBarChart;
    private PieChart<AbstractNode> sizePieChart;
    private ChartView<AbstractNode> sizePieView;
    private BarChart<AbstractNode> sizeBarChart;
    private ChartView<AbstractNode> sizeBarView;
    private PieChart<Object> sizeDistributionPieChart;
    private ChartView<Object> sizeDistributionPieView;
    private BarChart<Object> sizeDistributionBarChart;
    private ChartView<Object> sizeDistributionBarView;
    private PieChart<Object> modifiedDistributionPieChart;
    private ChartView<Object> modifiedDistributionPieView;
    private BarChart<Object> modifiedDistributionBarChart;
    private ChartView<Object> modifiedDistributionBarView;
    private PieChart<Object> accessedDistributionPieChart;
    private ChartView<Object> accessedDistributionPieView;
    private BarChart<Object> accessedDistributionBarChart;
    private ChartView<Object> accessedDistributionBarView;
    private PieChart<Object> typeDistributionPieChart;
    private ChartView<Object> typeDistributionPieView;
    private BarChart<Object> typeDistributionBarChart;
    private ChartView<Object> typeDistributionBarView;

    JDPresentationView(JDResultModel resultModel) {
        this.resultModel = resultModel;
        this.presentationModel = resultModel.getPresentationModel();
        this.initComponents();
    }

    private void initComponents() {
        this.cardPanel = new JGCardPanel();
        this.cardPanel.setBackground(JDResources.background());
        Format kbFormat = JDFormats.KILOBYTE_FORMAT;
        String totalSizeText = RESOURCES.getString("PresentationView.pieChart.total.size", new Object[0]);
        Font tableFont = UIManager.getFont("Table.font");
        Font smallFont = tableFont.deriveFont(tableFont.getSize2D() - 4.0f);
        this.overviewSizePieChart = new PieChart(kbFormat, totalSizeText);
        this.overviewSizePieChart.setShowSize(false);
        this.overviewSizePieChart.setShowTotal(false);
        this.overviewSizePieChart.setFont(smallFont);
        this.overviewSizePieChart.setModel(this.resultModel.getPresentationModel().getSizeChartModel());
        this.overviewSizeDistributionBarChart = new BarChart(kbFormat, false);
        this.overviewSizeDistributionBarChart.setShowSize(false);
        this.overviewSizeDistributionBarChart.setFont(smallFont);
        this.overviewSizeDistributionBarChart.setModel(this.resultModel.getPresentationModel().getSizeDistributionChartModel());
        this.overviewTimeDistributionBarChart = new BarChart(kbFormat, false);
        this.overviewTimeDistributionBarChart.setShowSize(false);
        this.overviewTimeDistributionBarChart.setFont(smallFont);
        this.overviewTimeDistributionBarChart.setModel(this.resultModel.getPresentationModel().getModifiedDistributionChartModel());
        this.sizePieChart = new PieChart(kbFormat, totalSizeText);
        this.sizePieChart.setModel(this.resultModel.getPresentationModel().getSizeChartModel());
        this.sizePieView = new ChartView<AbstractNode>(this.sizePieChart, false, null);
        this.sizeBarChart = new BarChart(kbFormat);
        this.sizeBarChart.setModel(this.resultModel.getPresentationModel().getSizeChartModel());
        this.sizeBarView = new ChartView<AbstractNode>(this.sizeBarChart, true, null);
        this.sizeDistributionPieChart = new PieChart(kbFormat, totalSizeText);
        this.sizeDistributionPieChart.setShowSize(false);
        this.sizeDistributionPieChart.setModel(this.resultModel.getPresentationModel().getSizeDistributionChartModel());
        this.sizeDistributionPieView = new ChartView<Object>(this.sizeDistributionPieChart, false, JDPresentationView.res.size);
        this.sizeDistributionBarChart = new BarChart(kbFormat, false);
        this.sizeDistributionBarChart.setModel(this.resultModel.getPresentationModel().getSizeDistributionChartModel());
        this.sizeDistributionBarView = new ChartView<Object>(this.sizeDistributionBarChart, true, JDPresentationView.res.size);
        this.modifiedDistributionPieChart = new PieChart(kbFormat, totalSizeText);
        this.modifiedDistributionPieChart.setModel(this.resultModel.getPresentationModel().getModifiedDistributionChartModel());
        this.modifiedDistributionPieView = new ChartView<Object>(this.modifiedDistributionPieChart, false, JDPresentationView.res.modifiedDistribution);
        this.modifiedDistributionBarChart = new BarChart(kbFormat, false);
        this.modifiedDistributionBarChart.setModel(this.resultModel.getPresentationModel().getModifiedDistributionChartModel());
        this.modifiedDistributionBarView = new ChartView<Object>(this.modifiedDistributionBarChart, true, JDPresentationView.res.modifiedDistribution);
        this.accessedDistributionPieChart = new PieChart(kbFormat, totalSizeText);
        this.accessedDistributionPieChart.setModel(this.resultModel.getPresentationModel().getAccessedDistributionChartModel());
        this.accessedDistributionPieView = new ChartView<Object>(this.accessedDistributionPieChart, false, JDPresentationView.res.accessedDistribution);
        this.accessedDistributionBarChart = new BarChart(kbFormat, false);
        this.accessedDistributionBarChart.setModel(this.resultModel.getPresentationModel().getAccessedDistributionChartModel());
        this.accessedDistributionBarView = new ChartView<Object>(this.accessedDistributionBarChart, true, JDPresentationView.res.accessedDistribution);
        this.typeDistributionPieChart = new PieChart(kbFormat, totalSizeText);
        this.typeDistributionPieChart.setModel(this.resultModel.getPresentationModel().getTypeDistributionChartModel());
        this.typeDistributionPieView = new ChartView<Object>(this.typeDistributionPieChart, true, JDPresentationView.res.typeDistribution);
        this.typeDistributionBarChart = new BarChart(kbFormat, false);
        this.typeDistributionBarChart.setModel(this.resultModel.getPresentationModel().getTypeDistributionChartModel());
        this.typeDistributionBarView = new ChartView<Object>(this.typeDistributionBarChart, true, JDPresentationView.res.typeDistribution);
    }

    JComponent buildPanel() {
        this.cardPanel.add((Component)this.buildSunburst(), GUISettings.ViewMode.SIZE_SUNBURST.name());
        this.cardPanel.add((Component)this.buildTreeMap(), GUISettings.ViewMode.SIZE_TREE_MAP.name());
        this.cardPanel.add((Component)this.sizePieView.buildPanel(), GUISettings.ViewMode.SIZE_PIE.name());
        this.cardPanel.add((Component)this.sizeBarView.buildPanel(), GUISettings.ViewMode.SIZE_BAR.name());
        this.cardPanel.add((Component)this.buildSizeTable(), GUISettings.ViewMode.SIZE_TABLE.name());
        this.cardPanel.add((Component)this.buildTop50LargestTable(), GUISettings.ViewMode.TOP50_LARGEST.name());
        this.cardPanel.add((Component)this.buildTop50LeastRecentlyModifiedTable(), GUISettings.ViewMode.TOP50_LEAST_RECENTLY_MODIFIED.name());
        this.cardPanel.add((Component)this.buildTop50MostRecentlyModifiedTable(), GUISettings.ViewMode.TOP50_MOST_RECENTLY_MODIFIED.name());
        this.cardPanel.add((Component)this.buildTop50LeastRecentlyAccessedTable(), GUISettings.ViewMode.TOP50_LEAST_RECENTLY_ACCESSED.name());
        this.cardPanel.add((Component)this.buildTop50MostRecentlyAccessedTable(), GUISettings.ViewMode.TOP50_MOST_RECENTLY_ACCESSED.name());
        this.cardPanel.add((Component)this.buildTop50LeastRecentlyUsedTable(), GUISettings.ViewMode.TOP50_LEAST_RECENTLY_USED.name());
        this.cardPanel.add((Component)this.buildTop50MostRecentlyUsedTable(), GUISettings.ViewMode.TOP50_MOST_RECENTLY_USED.name());
        this.cardPanel.add((Component)this.sizeDistributionPieView.buildPanel(), GUISettings.ViewMode.SIZE_DISTRIBUTION_PIE.name());
        this.cardPanel.add((Component)this.sizeDistributionBarView.buildPanel(), GUISettings.ViewMode.SIZE_DISTRIBUTION_BAR.name());
        this.cardPanel.add((Component)this.buildSizeDistributionTable(), GUISettings.ViewMode.SIZE_DISTRIBUTION_TABLE.name());
        this.cardPanel.add((Component)this.modifiedDistributionPieView.buildPanel(), GUISettings.ViewMode.MODIFIED_DISTRIBUTION_PIE.name());
        this.cardPanel.add((Component)this.modifiedDistributionBarView.buildPanel(), GUISettings.ViewMode.MODIFIED_DISTRIBUTION_BAR.name());
        this.cardPanel.add((Component)this.buildModifiedDistributionTable(), GUISettings.ViewMode.MODIFIED_DISTRIBUTION_TABLE.name());
        this.cardPanel.add((Component)this.accessedDistributionPieView.buildPanel(), GUISettings.ViewMode.ACCESSED_DISTRIBUTION_PIE.name());
        this.cardPanel.add((Component)this.accessedDistributionBarView.buildPanel(), GUISettings.ViewMode.ACCESSED_DISTRIBUTION_BAR.name());
        this.cardPanel.add((Component)this.buildAccessedDistributionTable(), GUISettings.ViewMode.ACCESSED_DISTRIBUTION_TABLE.name());
        this.cardPanel.add((Component)this.typeDistributionPieView.buildPanel(), GUISettings.ViewMode.TYPE_DISTRIBUTION_PIE.name());
        this.cardPanel.add((Component)this.typeDistributionBarView.buildPanel(), GUISettings.ViewMode.TYPE_DISTRIBUTION_BAR.name());
        this.cardPanel.add((Component)this.buildTypeDistributionTable(), GUISettings.ViewMode.TYPE_DISTRIBUTION_TABLE.name());
        this.initEventHandling();
        return this.cardPanel;
    }

    private JComponent buildSunburst() {
        return new SunburstChart<AbstractNode>(this.presentationModel.getTreeChartModel());
    }

    private JComponent buildTreeMap() {
        return new TreeMapChart<AbstractNode>(this.presentationModel.getTreeChartModel());
    }

    private JComponent buildSizeTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable();
        JDPresentationView.configureSizeTable(table);
        table.setModel(this.presentationModel.getSizeTableModel());
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildTop50LargestTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getLargestFilesTableModel());
        table.setSelectionModel(this.presentationModel.getLargestFilesSelectionModel());
        table.addMouseListener(Listeners.contextMenu(this.presentationModel::onLargestFileContextMenuRequested));
        JDPresentationView.configureTop50Table(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildTop50LeastRecentlyModifiedTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getLeastRecentlyModifiedFilesTableModel());
        JDPresentationView.configureTop50Table(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildTop50MostRecentlyModifiedTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getMostRecentlyModifiedFilesTableModel());
        JDPresentationView.configureTop50Table(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildTop50LeastRecentlyAccessedTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getLeastRecentlyAccessedFilesTableModel());
        JDPresentationView.configureTop50Table(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildTop50MostRecentlyAccessedTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getMostRecentlyAccessedFilesTableModel());
        JDPresentationView.configureTop50Table(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildTop50LeastRecentlyUsedTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getLeastRecentlyUsedFilesTableModel());
        JDPresentationView.configureTop50Table(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildTop50MostRecentlyUsedTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getMostRecentlyUsedFilesTableModel());
        JDPresentationView.configureTop50Table(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildSizeDistributionTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getSizeDistributionTableModel());
        JDPresentationView.configureDistributionTable(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildModifiedDistributionTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getModifiedDistributionTableModel());
        JDPresentationView.configureDistributionTable(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildAccessedDistributionTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getAccessedDistributionTableModel());
        JDPresentationView.configureDistributionTable(table);
        return JDPresentationView.scrolllable(table);
    }

    private JComponent buildTypeDistributionTable() {
        JGTable<AbstractNode> table = JDPresentationView.buildTable(this.presentationModel.getTypeDistributionTableModel());
        JDPresentationView.configureDistributionTable(table);
        return JDPresentationView.scrolllable(table);
    }

    private static JGTable<AbstractNode> buildTable(TableModel tableModel) {
        JGTable<AbstractNode> table = JDPresentationView.buildTable();
        table.setModel(tableModel);
        return table;
    }

    private static JGTable<AbstractNode> buildTable() {
        JGStripedTable<AbstractNode> table = new JGStripedTable<AbstractNode>();
        table.setAutoCreateRowSorter(true);
        table.setShowStripes(false);
        table.setShowGrid(false);
        table.setAutoResizeMode(0);
        table.getTableHeader().setReorderingAllowed(false);
        table.setDefaultRenderer(Object.class, JDRenderers.DEFAULT_RENDERER);
        table.setDefaultRenderer(Number.class, JDRenderers.NUMBER_RENDERER);
        return table;
    }

    private static void configureSizeTable(JGTable<AbstractNode> table) {
        new TableBuilder<AbstractNode>(table).beginColumn().layout("110dlu", new Object[0]).renderer(JDRenderers.NODE_RENDERER).endColumn().beginColumn().name("Size").layout("[70dlu, p]", new Object[0]).renderer(JDRenderers.SIZE_RENDERER).endColumn().beginColumn().name("Count").layout("[70dlu, p]", new Object[0]).renderer(JDRenderers.COUNT_RENDERER).endColumn().beginColumn().name("Absolute %").layout("[50dlu, p]", new Object[0]).renderer(JDRenderers.PERCENT_RENDERER).endColumn().beginColumn().name("Relative %").layout("[50dlu, p]", new Object[0]).renderer(JDRenderers.PERCENT_RENDERER).endColumn().build();
        JDPresentationView.configurePreferredColumnWidths(table, 110, 70, 70, 50, 50);
    }

    private static void configureTop50Table(JGTable<AbstractNode> table) {
        TableColumns.on(table).render(1).with(JDRenderers.NODE_RENDERER).render(2).with(JDRenderers.SIZE_RENDERER).render(3).with(JDRenderers.DATE_TIME_RENDERER).render(4).with(JDRenderers.DATE_TIME_RENDERER).render(5).with(JDRenderers.DIRECTOY_PATH_RENDERER);
        JDPresentationView.configurePreferredColumnWidths(table, 20, 110, 70, 70, 70, 500);
    }

    private static void configureDistributionTable(JGTable<AbstractNode> table) {
        table.setRowSelectionAllowed(false);
        TableColumns.on(table).render(0).with(JDRenderers.RIGHT_ALIGNED_DEFAULT_RENDERER).render(1).with(JDRenderers.SIZE_RENDERER).render(2).with(JDRenderers.PERCENT_RENDERER).render(3).with(JDRenderers.COUNT_RENDERER).render(4).with(JDRenderers.PERCENT_RENDERER);
        JDPresentationView.configurePreferredColumnWidths(table, 110, 70, 50, 70, 50);
    }

    private static void configurePreferredColumnWidths(JTable table, int ... preferredWidthsDLU) {
        for (int i = 0; i < preferredWidthsDLU.length; ++i) {
            int dlu = preferredWidthsDLU[i];
            if (dlu <= 0) continue;
            int preferredWidth = Sizes.dialogUnitXAsPixel(dlu, table);
            table.getColumnModel().getColumn(i).setPreferredWidth(preferredWidth);
        }
    }

    private static JComponent scrolllable(JGTable<AbstractNode> table) {
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBorder(new ScrollPaneBorder(true, false, false, false));
        scrollPane.getViewport().setBackground(Color.WHITE);
        return scrollPane;
    }

    private void initEventHandling() {
        this.resultModel.getGuiSettings().addPropertyChangeListener(this::onGuiSettingsChanged);
        this.updatePresentation(this.resultModel.getGuiSettings().getViewMode());
    }

    private void onGuiSettingsChanged(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "viewMode": {
                this.updatePresentation((GUISettings.ViewMode)((Object)evt.getNewValue()));
                break;
            }
            case "sizeMode": {
                this.updateChartSettings();
                break;
            }
        }
    }

    private void updatePresentation(GUISettings.ViewMode viewMode) {
        this.cardPanel.showCard(viewMode.name());
    }

    private void updateChartSettings() {
        GUISettings.SizeMode sizeMode = this.resultModel.getGuiSettings().getSizeMode();
        Format pieFormat = sizeMode == GUISettings.SizeMode.SIZE ? JDFormats.KILOBYTE_FORMAT : JDFormats.COUNT_FORMAT_LONG;
        Format barFormat = sizeMode == GUISettings.SizeMode.SIZE ? JDFormats.KILOBYTE_FORMAT : JDFormats.FILE_COUNT_FORMAT;
        String totalTextKeySuffix = sizeMode == GUISettings.SizeMode.SIZE ? "size" : "count";
        String totalText = RESOURCES.getString("PresentationView.pieChart.total." + totalTextKeySuffix, new Object[0]);
        this.overviewSizeDistributionBarChart.setFormat(barFormat);
        this.overviewTimeDistributionBarChart.setFormat(barFormat);
        this.sizePieChart.setFormat(pieFormat);
        this.sizePieChart.setTotalText(totalText);
        this.sizeBarChart.setFormat(barFormat);
        this.sizeDistributionPieChart.setFormat(pieFormat);
        this.sizeDistributionPieChart.setTotalText(totalText);
        this.sizeDistributionBarChart.setFormat(barFormat);
        this.modifiedDistributionPieChart.setFormat(pieFormat);
        this.modifiedDistributionPieChart.setTotalText(totalText);
        this.modifiedDistributionBarChart.setFormat(barFormat);
        this.accessedDistributionPieChart.setFormat(pieFormat);
        this.accessedDistributionPieChart.setTotalText(totalText);
        this.accessedDistributionBarChart.setFormat(barFormat);
        this.typeDistributionPieChart.setFormat(pieFormat);
        this.typeDistributionPieChart.setTotalText(totalText);
        this.typeDistributionBarChart.setFormat(barFormat);
    }
}

