/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.component;

import com.jgoodies.binding.binder.BeanBinder;
import com.jgoodies.binding.binder.Binders;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.jsdl.JSDLCommonSetup;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.dialogs.core.style.StyleManager;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public final class ExpandableView
extends Bean {
    public static final String PROPERTY_EXPANDED = "expanded";
    private JComponent collapsedView;
    private String collapsedToolTipText;
    private JComponent expandedView;
    private String expandedToolTipText;
    private JComponent containerView;
    private JToggleButton expansionControl;
    private boolean expanded = false;
    private boolean panelExpansionEnabled = false;

    public ExpandableView() {
        this.initComponents();
        this.initEventHandling();
        this.initBindings();
    }

    public ExpandableView(JComponent collapsedView, String collapsedToolTipText, JComponent expandedView, String expandedToolTipText) {
        this();
        this.setCollapsedView(collapsedView);
        this.setCollapsedToolTipText(collapsedToolTipText);
        this.setExpandedView(expandedView);
        this.setExpandedToolTipText(expandedToolTipText);
    }

    public void setCollapsedView(JComponent collapsedView) {
        this.collapsedView = collapsedView;
        this.updateExpansionState();
    }

    public void setCollapsedToolTipText(String collapsedToolTipText) {
        this.collapsedToolTipText = collapsedToolTipText;
        this.updateExpansionState();
    }

    public void setExpandedView(JComponent expandedView) {
        this.expandedView = expandedView;
        this.updateExpansionState();
    }

    public void setExpandedToolTipText(String expandedToolTipText) {
        this.expandedToolTipText = expandedToolTipText;
        this.updateExpansionState();
    }

    public boolean isPanelExpansionEnabled() {
        return this.panelExpansionEnabled;
    }

    public void setPanelExpansionEnabled(boolean newValue) {
        this.panelExpansionEnabled = newValue;
    }

    private void initComponents() {
        this.containerView = new JPanel(new BorderLayout());
        this.containerView.setOpaque(false);
        this.expansionControl = ExpandableView.createExpansionButton();
    }

    private void initEventHandling() {
        this.containerView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExpandableView.this.onPanelClicked(evt);
            }
        });
    }

    private void initBindings() {
        BeanBinder binder = Binders.binderFor(this);
        binder.bindProperty(PROPERTY_EXPANDED).to(this.expansionControl);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean newValue) {
        boolean oldValue = this.isExpanded();
        this.expanded = newValue;
        this.updateExpansionState();
        this.firePropertyChange(PROPERTY_EXPANDED, oldValue, newValue);
    }

    public JComponent getView() {
        return this.containerView;
    }

    public JComponent getExpansionControl() {
        return this.expansionControl;
    }

    private void onPanelClicked(MouseEvent evt) {
        if (this.isPanelExpansionEnabled()) {
            this.setExpanded(!this.isExpanded());
        }
    }

    private void updateExpansionState() {
        String toolTip;
        Icon pressedIcon;
        JComponent currentView;
        if (this.isExpanded()) {
            currentView = this.expandedView;
            pressedIcon = UIManager.getIcon("ExpandedControl.pressedIcon");
            toolTip = this.expandedToolTipText;
        } else {
            currentView = this.collapsedView;
            pressedIcon = UIManager.getIcon("CollapsedControl.pressedIcon");
            toolTip = this.collapsedToolTipText;
        }
        this.containerView.removeAll();
        if (currentView != null) {
            this.containerView.add(currentView);
        }
        this.containerView.revalidate();
        this.containerView.repaint();
        this.expansionControl.setToolTipText(toolTip);
        this.expansionControl.setPressedIcon(pressedIcon);
    }

    private static JToggleButton createExpansionButton() {
        Icon deselectedIcon = UIManager.getIcon("CollapsedControl.icon");
        Icon rolloverIcon = UIManager.getIcon("CollapsedControl.rolloverIcon");
        Icon selectedIcon = UIManager.getIcon("ExpandedControl.icon");
        Icon rolloverSelectedIcon = UIManager.getIcon("ExpandedControl.rolloverIcon");
        if (deselectedIcon == null) {
            throw new MissingResourceException("Mising UIManager icon.", "ExpandableView", "CollapsedControl.icon");
        }
        if (selectedIcon == null) {
            throw new MissingResourceException("Mising UIManager icon.", "ExpandableView", "ExpandedControl.icon");
        }
        JToggleButton button = new JToggleButton(deselectedIcon);
        button.setName("expansion");
        button.setSelectedIcon(selectedIcon);
        button.setRolloverIcon(rolloverIcon);
        button.setRolloverSelectedIcon(rolloverSelectedIcon);
        button.setContentAreaFilled(false);
        button.setRolloverEnabled(true);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(false);
        button.setFocusable(JSDLCommonSetup.isOptimizedForScreenReader());
        FocusTraversalUtils.markAsPoorDefaultFocusOwner(button);
        if (SystemUtils.IS_OS_MAC) {
            button.putClientProperty("JComponent.sizeVariant", "regular");
            button.putClientProperty("JButton.buttonType", "normal");
        }
        return button;
    }

    static {
        StyleManager.getStyle();
    }
}

