/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.choice.list_builder;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.basics.BasicDialogResources;
import com.jgoodies.dialogs.basics.choice.list_builder.AbstractListBuilderModel;
import com.jgoodies.dialogs.basics.choice.list_builder.ListBuilderPanelBuilder;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;

public abstract class AbstractListBuilderView<E, LBM extends AbstractListBuilderModel<E>, OV extends JComponent, BLV extends JComponent>
extends Bean {
    public static final String PROPERTY_ADD_ALL_REMOVE_ALL_VISIBLE = "addAllRemoveAllVisible";
    public static final String PROPERTY_MOVE_UP_MOVE_DOWN_VISIBLE = "moveUpMoveDownVisible";
    private static final ResourceMap RESOURCES = Application.getResourceMap(BasicDialogResources.class);
    protected final LBM model;
    private final ListBuilderPanelBuilder panelBuilder;
    private JGComponentFactory factory;
    private JComponent optionsLabel;
    private OV optionsView;
    private JComponent builtListLabel;
    private BLV builtListView;
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private String namePrefix = "ListBuilderView";
    private MouseListener optionsDoubleClickListener;
    private MouseListener builtListDoubleClickListener;
    private boolean addAllRemoveAllVisible = false;
    private boolean moveUpMoveDownVisible = false;

    public AbstractListBuilderView(LBM model) {
        this.model = model;
        this.panelBuilder = new ListBuilderPanelBuilder();
        this.initComponents();
        if (model != null) {
            this.optionsDoubleClickListener = Listeners.mouseDoubleClicked(arg_0 -> model.onOptionsMouseDoubleClicked(arg_0));
            this.builtListDoubleClickListener = Listeners.mouseDoubleClicked(arg_0 -> model.onBuiltListMouseDoubleClicked(arg_0));
            this.initEventHandling();
        }
    }

    private void initComponents() {
        JGComponentFactory factory = this.getFactory();
        this.addButton = factory.createButton();
        this.removeButton = factory.createButton();
        this.addAllButton = factory.createButton();
        this.removeAllButton = factory.createButton();
        this.moveUpButton = factory.createButton();
        this.moveDownButton = factory.createButton();
        this.setName(this.addButton, "addButton");
        this.setName(this.removeButton, "removeButton");
        this.setName(this.addAllButton, "addAllButton");
        this.setName(this.removeAllButton, "removeAllButton");
        this.setName(this.moveUpButton, "moveUpButton");
        this.setName(this.moveDownButton, "moveDownButton");
    }

    private void initEventHandling() {
        this.addButton.setAction(((AbstractListBuilderModel)this.model).getAddAction());
        this.removeButton.setAction(((AbstractListBuilderModel)this.model).getRemoveAction());
        this.addAllButton.setAction(((AbstractListBuilderModel)this.model).getAddAllAction());
        this.removeAllButton.setAction(((AbstractListBuilderModel)this.model).getRemoveAllAction());
        this.moveDownButton.setAction(((AbstractListBuilderModel)this.model).getMoveDownAction());
        this.moveUpButton.setAction(((AbstractListBuilderModel)this.model).getMoveUpAction());
        ((AbstractListBuilderModel)this.model).getBuiltListDataModel().addListDataListener(Listeners.listData(this::onBuiltListListDataChanged));
        ((AbstractListBuilderModel)this.model).getBuiltListSelectionModel().addListSelectionListener(Listeners.nonAdjustingListSelection(this::onBuiltListListSelectionChanged));
    }

    public final void setFactory(JGComponentFactory factory) {
        this.factory = factory;
    }

    public final void setNamePrefix(String prefix) {
        this.namePrefix = prefix;
    }

    public final JComponent getOptionsLabel() {
        if (this.optionsLabel == null) {
            this.setOptionsLabel(this.createDefaultOptionsLabel());
        }
        return this.optionsLabel;
    }

    public final void setOptionsLabel(JComponent optionsLabel) {
        this.optionsLabel = Preconditions.checkNotNull(optionsLabel, "The %s must not be null.", "options label");
        this.overrideNameIfBlank(optionsLabel, "optionsLabel");
    }

    public final void setOptionsLabelText(String markedText, Object ... args) {
        this.setOptionsLabel(this.getFactory().createLabel(Strings.get(markedText, args)));
    }

    public final void setOptionsFilterView(JComponent view) {
        this.panelBuilder.optionsFilterView(view);
    }

    public final OV getOptionsView() {
        if (this.optionsView == null) {
            this.setOptionsView(this.createDefaultOptionsView());
        }
        return this.optionsView;
    }

    public void setOptionsView(OV newOptionsView) {
        Preconditions.checkNotNull(newOptionsView, "The %s must not be null.", "options view");
        this.overrideNameIfBlank((JComponent)newOptionsView, "optionsView");
        if (this.optionsView != null) {
            ((Component)this.optionsView).removeMouseListener(this.optionsDoubleClickListener);
        }
        this.optionsView = newOptionsView;
        ((Component)this.optionsView).addMouseListener(this.optionsDoubleClickListener);
    }

    public final void setOptionsSummaryView(JComponent view) {
        this.panelBuilder.optionsSummaryView(view);
    }

    public final JComponent getBuiltListLabel() {
        if (this.builtListLabel == null) {
            this.setBuiltListLabel(this.createDefaultBuiltListLabel());
        }
        return this.builtListLabel;
    }

    public final void setBuiltListLabel(JComponent builtListLabel) {
        this.builtListLabel = Preconditions.checkNotNull(builtListLabel, "The %s must not be null.", "built list label");
        this.overrideNameIfBlank(builtListLabel, "builtListLabel");
    }

    public final void setBuiltListLabelText(String markedText, Object ... args) {
        this.setBuiltListLabel(this.getFactory().createLabel(Strings.get(markedText, args)));
    }

    public final void setBuiltListFilterView(JComponent view) {
        this.panelBuilder.builtListFilterView(view);
    }

    public final BLV getBuiltListView() {
        if (this.builtListView == null) {
            this.setBuiltListView(this.createDefaultBuiltListView());
        }
        return this.builtListView;
    }

    public void setBuiltListView(BLV newBuiltListView) {
        Preconditions.checkNotNull(newBuiltListView, "The %s must not be null.", "built list view");
        this.overrideNameIfBlank((JComponent)newBuiltListView, "builtListView");
        if (this.builtListView != null) {
            ((Component)this.builtListView).removeMouseListener(this.builtListDoubleClickListener);
        }
        this.builtListView = newBuiltListView;
        ((Component)this.builtListView).addMouseListener(this.builtListDoubleClickListener);
    }

    public final void setBuiltListSummaryView(JComponent view) {
        this.panelBuilder.builtListSummaryView(view);
    }

    public final void setListViewColumn(String columnSpecification) {
        this.panelBuilder.listViewColumn(columnSpecification);
    }

    public final void setListViewRow(String rowSpecification) {
        this.panelBuilder.listViewRow(rowSpecification);
    }

    public final boolean isAddAllRemoveAllVisible() {
        return this.addAllRemoveAllVisible;
    }

    public final void setAddAllRemoveAllVisible(boolean newValue) {
        this.addAllRemoveAllVisible = newValue;
        this.firePropertyChange(PROPERTY_ADD_ALL_REMOVE_ALL_VISIBLE, this.addAllRemoveAllVisible, this.addAllRemoveAllVisible);
    }

    public final boolean isMoveUpMoveDownVisible() {
        return this.moveUpMoveDownVisible;
    }

    public final void setMoveUpMoveDownVisible(boolean newValue) {
        this.moveUpMoveDownVisible = newValue;
        this.firePropertyChange(PROPERTY_MOVE_UP_MOVE_DOWN_VISIBLE, this.moveUpMoveDownVisible, this.moveUpMoveDownVisible);
    }

    public JComponent buildPanel() {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        buttons.add(this.addButton);
        buttons.add(this.removeButton);
        if (this.addAllRemoveAllVisible) {
            buttons.add(null);
            buttons.add(this.addAllButton);
            buttons.add(this.removeAllButton);
        }
        if (this.moveUpMoveDownVisible) {
            buttons.add(null);
            buttons.add(this.moveUpButton);
            buttons.add(this.moveDownButton);
        }
        return this.panelBuilder.optionsLabel(this.getOptionsLabel()).optionsView((JComponent)this.getOptionsView()).builtListLabel(this.getBuiltListLabel()).builtListView((JComponent)this.getBuiltListView()).buttons(buttons.toArray(new JButton[buttons.size()])).build();
    }

    private void onBuiltListListDataChanged(ListDataEvent evt) {
        this.handleBuiltListDataChanged();
    }

    private void onBuiltListListSelectionChanged(ListSelectionEvent evt) {
        this.handleBuiltListSelectionChanged();
    }

    protected void handleBuiltListDataChanged() {
    }

    protected void handleBuiltListSelectionChanged() {
    }

    protected abstract OV createDefaultOptionsView();

    protected abstract BLV createDefaultBuiltListView();

    protected JComponent createDefaultOptionsLabel() {
        return this.getFactory().createLabel(RESOURCES.getString("ListBuilder.defaultOptionsLabel.text", new Object[0]));
    }

    protected JComponent createDefaultBuiltListLabel() {
        return this.getFactory().createLabel(RESOURCES.getString("ListBuilder.defaultBuiltListLabel.text", new Object[0]));
    }

    protected final JList<E> createDefaultBuiltListList() {
        JList<Object> list = this.getFactory().createList(new Object[0]);
        list.setModel(((AbstractListBuilderModel)this.model).getBuiltListDataModel());
        list.setSelectionModel(((AbstractListBuilderModel)this.model).getBuiltListSelectionModel());
        return list;
    }

    protected final JGComponentFactory getFactory() {
        if (this.factory == null) {
            this.factory = JGComponentFactory.getCurrent();
        }
        return this.factory;
    }

    protected void overrideNameIfBlank(JComponent component, String suffix) {
        if (component != null && Strings.isBlank(component.getName())) {
            this.setName(component, suffix);
        }
    }

    private void setName(JComponent component, String suffix) {
        component.setName(this.namePrefix + '.' + suffix);
    }
}

