/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.choice;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.list.ListViewModel;
import com.jgoodies.components.JGCheckBoxList;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.renderer.JGDefaultListCellRenderer;
import com.jgoodies.dialogs.basics.choice.ListReturnValue;
import com.jgoodies.dialogs.basics.internal.JSDLBasicsUtils;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.internal.AbstractPaneBuilder;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.builder.ListViewBuilder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public final class MultipleSelectionPaneBuilder<V>
extends AbstractPaneBuilder<TaskPane, MultipleSelectionPaneBuilder<V>> {
    private final ListViewModel<V> model = new ListViewModel();
    private final TaskPaneBuilder builder = new TaskPaneBuilder();
    private String supplementalInstructionText;
    private ListCellRenderer<? super V> cellRenderer;

    public MultipleSelectionPaneBuilder() {
        this.builder.internalPreferredWidth(PreferredWidth.SMALL);
    }

    public MultipleSelectionPaneBuilder<V> mainInstructionText(String text, Object ... args) {
        this.builder.mainInstructionText(text, args);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> supplementalInstructionText(String text, Object ... args) {
        this.supplementalInstructionText = Strings.get(text, args);
        Preconditions.checkNotBlank(this.supplementalInstructionText, "The %s must not be null, empty, or whitespace.", "supplemental instruction");
        return this;
    }

    public MultipleSelectionPaneBuilder<V> verificationText(String markedText, Object ... args) {
        this.builder.verificationText(markedText, args);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> verificationSelected(boolean b) {
        this.builder.verificationSelected(b);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> verification(Verification verification) {
        this.builder.verification(verification);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> preferredWidth(int customValue) {
        this.builder.preferredWidth(customValue);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> preferredWidth(PreferredWidth standardizedValue) {
        this.builder.preferredWidth(standardizedValue);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> aspectRatio(double customValue) {
        this.builder.aspectRatio(customValue);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> aspectRatio(AspectRatio standardizedValue) {
        this.builder.aspectRatio(standardizedValue);
        return this;
    }

    @Override
    public MultipleSelectionPaneBuilder<V> resizable(boolean resizable) {
        return (MultipleSelectionPaneBuilder)super.resizable(resizable);
    }

    @Override
    public MultipleSelectionPaneBuilder<V> minimumSize(Dimension minimumSize) {
        return (MultipleSelectionPaneBuilder)super.minimumSize(minimumSize);
    }

    @Override
    public MultipleSelectionPaneBuilder<V> minimumSize(int minimumWidth, int minimumHeight) {
        return (MultipleSelectionPaneBuilder)super.minimumSize(minimumWidth, minimumHeight);
    }

    @Override
    public MultipleSelectionPaneBuilder<V> maximumSize(Dimension minimumSize) {
        return (MultipleSelectionPaneBuilder)super.maximumSize(minimumSize);
    }

    @Override
    public MultipleSelectionPaneBuilder<V> maximumSize(int maximumWidth, int maximumHeight) {
        return (MultipleSelectionPaneBuilder)super.maximumSize(maximumWidth, maximumHeight);
    }

    public MultipleSelectionPaneBuilder<V> items(List<V> items) {
        this.model.setItems(items);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> items(V ... items) {
        this.model.setItems(items);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> selectedItems(List<V> initialSelection) {
        this.model.setIncludedItems(initialSelection);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> selectedItems(V ... initialSelection) {
        this.model.setIncludedItems(initialSelection);
        return this;
    }

    public MultipleSelectionPaneBuilder<V> cellFormatter(Function<? super V, String> formatter) {
        return this.cellRenderer(new JGDefaultListCellRenderer<V>(formatter));
    }

    public MultipleSelectionPaneBuilder<V> cellRenderer(ListCellRenderer<? super V> renderer) {
        this.cellRenderer = renderer;
        return this;
    }

    private TaskPane build() {
        MultipleSelectionPaneBuilder.checkMainInstructionNotBlank(this.builder.build().getMainInstructionText());
        CheckBoxListView view = new CheckBoxListView(this);
        this.builder.mainInstructionLabelsContent(true);
        this.builder.marginContentTop(0);
        this.builder.content(view.buildContent());
        this.builder.commitCommands(CommandValue.OK, CommandValue.CANCEL);
        this.checkStyle();
        return this.builder.build();
    }

    public ListReturnValue<V> showDialog() {
        boolean cancelled = this.showDialogReturnCancelled(this.build());
        return new ListReturnValue<V>(cancelled, this.model.getIncludedItems(), this.model.getIncludedIndices());
    }

    @Override
    protected String getTitle() {
        if (this.title == null) {
            this.title = JSDLBasicsUtils.getApplicationTitle();
        }
        return this.title;
    }

    private void checkStyle() {
        MultipleSelectionPaneBuilder.checkMainInstructionNotBlank(this.builder.build().getMainInstructionText());
        MultipleSelectionPaneBuilder.checkSupplementalInstructionNullOrNotBlank(this.builder.build().getContentText());
    }

    private static void checkMainInstructionNotBlank(String mainInstruction) {
        Preconditions.checkNotBlank(mainInstruction, "The %s must not be null, empty, or whitespace.", "main instruction");
    }

    private static void checkSupplementalInstructionNullOrNotBlank(String supplementalInstruction) {
        if (supplementalInstruction != null) {
            Preconditions.checkNotBlank(supplementalInstruction, "The supplemental instruction must not be empty, or whitespace.");
        }
        JSDLCoreStyleChecker.getInstance().checkSupplementalInstructionIsTrimmed(supplementalInstruction);
    }

    public static final class CheckBoxListView<E> {
        private final MultipleSelectionPaneBuilder<E> builder;
        private final JGComponentFactory factory;
        private JComponent supplementalInstruction;
        private JGCheckBoxList<E> list;
        private JButton selectAllButton;
        private JButton clearAllButton;

        CheckBoxListView(MultipleSelectionPaneBuilder<E> builder) {
            this.builder = builder;
            this.factory = JGComponentFactory.getCurrent();
            this.initComponents();
            this.initBindings();
            this.initEventHandling();
        }

        private void initComponents() {
            this.list = new JGCheckBoxList();
            if (((MultipleSelectionPaneBuilder)this.builder).cellRenderer != null) {
                this.list.setCellRenderer(((MultipleSelectionPaneBuilder)this.builder).cellRenderer);
            }
            this.selectAllButton = this.factory.createButton(CoreDialogResources.getString("common.select_all.boxes"));
            this.clearAllButton = this.factory.createButton(CoreDialogResources.getString("common.clear_all.boxes"));
            if (Strings.isNotBlank(((MultipleSelectionPaneBuilder)this.builder).supplementalInstructionText)) {
                this.supplementalInstruction = this.factory.createStaticText(((MultipleSelectionPaneBuilder)this.builder).supplementalInstructionText, new Object[0]);
            }
        }

        private void initBindings() {
            this.list.setModel(this.getModel().getDataModel());
            this.list.setSelectionModel(this.getModel().getSelectionModel());
            this.list.setInclusionModel(this.getModel().getInclusionModel());
        }

        private void initEventHandling() {
            this.selectAllButton.addActionListener(this::onSelectAllPerformed);
            this.clearAllButton.addActionListener(this::onClearAllPerformed);
        }

        private void onSelectAllPerformed(ActionEvent evt) {
            this.getModel().includeAll();
        }

        private void onClearAllPerformed(ActionEvent evt) {
            this.getModel().clearInclusions();
        }

        JComponent buildContent() {
            boolean hasSupplementalInstruction = this.supplementalInstruction != null;
            return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:default:grow", new Object[0])).rows("fill:default:grow, %s, p", hasSupplementalInstruction ? "$pg" : "0")).add(this.buildListView()).xy(1, 1)).add(this.supplementalInstruction).xy(1, 3)).build();
        }

        private JComponent buildListView() {
            return new ListViewBuilder().listView(this.list).listBar(this.selectAllButton, this.clearAllButton).build();
        }

        private ListViewModel<E> getModel() {
            return ((MultipleSelectionPaneBuilder)this.builder).model;
        }
    }
}

