/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.content.preferences;

import com.jgoodies.app.gui.content.preferences.AppPreferencesModel;
import com.jgoodies.app.gui.content.preferences.AppPreferencesResources;
import com.jgoodies.binding.binder.Binders;
import com.jgoodies.binding.binder.PresentationModelBinder;
import com.jgoodies.common.jsdl.i18n.Resources;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGHyperlink;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.pane.property.PropertyPaneBuilder;
import com.jgoodies.framework.setup.BodyTextMode;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Paddings;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public final class AppPreferencesView {
    private static AppPreferencesResources resources = Resources.get(AppPreferencesResources.class);
    private final AppPreferencesModel model;
    private JComboBox<BodyTextMode> bodyTextModeCombo;
    private JCheckBox optimizedForScreenReaderBox;
    private JGHyperlink resetVerificationsLink;
    private JComponent infoText;

    public AppPreferencesView(AppPreferencesModel model) {
        this.model = model;
        this.initComponents();
        if (model != null) {
            this.initBindings();
            this.initEventHandling();
        }
    }

    private void initComponents() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.bodyTextModeCombo = factory.createComboBox(AppPreferencesView::displayString, (E[])new BodyTextMode[]{BodyTextMode.CLASSIC, BodyTextMode.LARGER});
        this.bodyTextModeCombo.setPrototypeDisplayValue(BodyTextMode.CLASSIC);
        this.optimizedForScreenReaderBox = factory.createCheckBox(AppPreferencesView.resources.optimizeForScreenReader);
        this.resetVerificationsLink = factory.createTaskLink();
        this.infoText = factory.createStaticText(AppPreferencesView.resources.helpMessage, new Object[0]);
    }

    private static String displayString(BodyTextMode mode) {
        switch (mode) {
            case CLASSIC: {
                return AppPreferencesView.resources.bodyTextMode_classic;
            }
            case LARGER: {
                return AppPreferencesView.resources.bodyTextMode_larger;
            }
        }
        throw new IllegalStateException("Unknown BodyTextMode " + mode);
    }

    private void initBindings() {
        PresentationModelBinder binder = Binders.binderFor(this.model);
        binder.bindBeanProperty("bodyTextMode").to(this.bodyTextModeCombo);
        binder.bindBeanProperty("optimizedForScreenReader").to(this.optimizedForScreenReaderBox);
    }

    private void initEventHandling() {
        this.resetVerificationsLink.setAction(this.model.getResetVerificationsAction());
    }

    public void showDialog(EventObject evt) {
        ((PropertyPaneBuilder)((PropertyPaneBuilder)((PropertyPaneBuilder)((PropertyPaneBuilder)((PropertyPaneBuilder)new PropertyPaneBuilder().owner(evt)).title(AppPreferencesView.resources.title, new Object[0])).content(this.buildContent(true)).commitModel(this.model != null ? this.model.getPropertyPaneModel() : null)).preferredWidth(PreferredWidth.MEDIUM)).aspectRatio(AspectRatio.NARROW)).showDialog();
    }

    public JComponent buildContent() {
        return this.buildContent(false);
    }

    private JComponent buildContent(boolean padding) {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("pref:grow", new Object[0])).rows("p, $lcg, p, $lg, p, $lg, p, $lg, p, $pg:grow, d", new Object[0])).padding(padding ? Paddings.DIALOG : Paddings.EMPTY)).add(AppPreferencesView.resources.bodyTextMode, new Object[0]).xy(1, 1)).add(this.bodyTextModeCombo).xy(1, 3, "l, c")).add(this.optimizedForScreenReaderBox).xy(1, 7)).add(this.resetVerificationsLink).xy(1, 9, "l, c")).add(this.infoText).xy(1, 11)).build();
    }
}

