/* Apathy 1.1
 *
 * Namespace: APATH_ / apath_
 */

/* Copyright (c) 2009, The Static Void Project
 *
 * Permission to use, copy, modify, and/or distribute this software for 
 * any purpose with or without fee is hereby granted, provided that the 
 * above copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef APATHY_H
#define APATHY_H


/* Distance type */
typedef int APATH_DISTANCE;

/* Coordinate type */
typedef int APATH_COORD;

/* Point type */
typedef struct APATH_POINT {

        APATH_COORD	y;
        APATH_COORD	x;

} APATH_POINT;

/* Boolean type */
typedef int		APATH_BOOL;
enum {APATH_FALSE, APATH_TRUE};

/* Move cost type */
typedef short		APATH_MOVE_COST;

/* Search depth type */
typedef int		APATH_SEARCH_DEPTH;

/* Step index type */
typedef int		APATH_STEP_INDEX;

/* Infinity constant */
#define APATH_INFINITY	-1



/* Function prototypes
 */
APATH_BOOL	apath_init(APATH_DISTANCE, APATH_DISTANCE);
void		apath_quit(void);

void		apath_search_depth(APATH_SEARCH_DEPTH);

APATH_BOOL	apath_find(APATH_COORD, APATH_COORD,
                        APATH_COORD, APATH_COORD
                );

APATH_MOVE_COST	apath_cost(void);

APATH_POINT *	apath_next_step(void);
APATH_POINT *	apath_x_step(APATH_STEP_INDEX);


/* A program which wants to use Apathy must implement this function */
APATH_MOVE_COST	apath_move_cost(APATH_COORD, APATH_COORD);


#endif

