/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.reflect.Method;
import java.util.List;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.AbstractRuleInterceptor;
import org.spockframework.runtime.model.FieldInfo;

public class MethodRuleInterceptor
extends AbstractRuleInterceptor {
    MethodRuleInterceptor(List<FieldInfo> ruleFields) {
        super(ruleFields);
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        Statement statement = this.createBaseStatement(invocation);
        FrameworkMethod method = this.createFrameworkMethod(invocation);
        for (FieldInfo field : this.ruleFields) {
            MethodRule rule = (MethodRule)this.getRuleInstance(field, invocation.getInstance());
            statement = rule.apply(statement, method, invocation.getInstance());
        }
        statement.evaluate();
    }

    private FrameworkMethod createFrameworkMethod(final IMethodInvocation invocation) {
        return new FrameworkMethod((Method)invocation.getMethod().getReflection()){

            public String getName() {
                return invocation.getIteration().getDescription().getMethodName();
            }
        };
    }
}

