/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.condition;

import java.util.List;
import org.spockframework.runtime.condition.EditOperation;
import org.spockframework.util.TextUtil;

public class EditPathRenderer {
    public String render(CharSequence seq1, CharSequence seq2, List<EditOperation> ops) {
        int index1 = 0;
        int index2 = 0;
        StringBuilder line1 = new StringBuilder();
        StringBuilder line2 = new StringBuilder();
        EditOperation.Kind prevKind = EditOperation.Kind.SKIP;
        for (EditOperation op : ops) {
            if (prevKind == EditOperation.Kind.SKIP ^ op.getKind() == EditOperation.Kind.SKIP) {
                String delimiter = prevKind == EditOperation.Kind.SKIP ? "(" : ")";
                line1.append(delimiter);
                line2.append(delimiter);
            }
            switch (op.getKind()) {
                case DELETE: {
                    String part;
                    for (int i = 0; i < op.getLength(); ++i) {
                        part = TextUtil.escape(seq1.charAt(index1++));
                        line1.append(part);
                        line2.append(part.length() == 1 ? "-" : "-~");
                    }
                    break;
                }
                case INSERT: {
                    String part;
                    for (int i = 0; i < op.getLength(); ++i) {
                        line1.append((part = TextUtil.escape(seq2.charAt(index2++))).length() == 1 ? "-" : "-~");
                        line2.append(part);
                    }
                    break;
                }
                case SKIP: 
                case SUBSTITUTE: {
                    for (int i = 0; i < op.getLength(); ++i) {
                        String part1 = TextUtil.escape(seq1.charAt(index1++));
                        String part2 = TextUtil.escape(seq2.charAt(index2++));
                        line1.append(part1);
                        line2.append(part2);
                        if (part1.length() < part2.length()) {
                            line1.append('~');
                            continue;
                        }
                        if (part2.length() >= part1.length()) continue;
                        line2.append('~');
                    }
                    break;
                }
            }
            prevKind = op.getKind();
        }
        if (prevKind != EditOperation.Kind.SKIP) {
            line1.append(")");
            line2.append(")");
        }
        return line1.toString() + "\n" + line2.toString();
    }
}

