/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IMockMethod;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.mock.runtime.DelegatingMockInvocation;
import org.spockframework.util.TextUtil;

public class MockInvocation
implements IMockInvocation {
    private final IMockObject mockObject;
    private final IMockMethod method;
    private final List<Object> arguments;
    private final IResponseGenerator realMethodInvoker;

    public MockInvocation(IMockObject mockObject, IMockMethod method, List<Object> arguments, IResponseGenerator realMethodInvoker) {
        this.mockObject = mockObject;
        this.method = method;
        this.arguments = arguments;
        this.realMethodInvoker = realMethodInvoker;
    }

    @Override
    public IMockObject getMockObject() {
        return this.mockObject;
    }

    @Override
    public IMockMethod getMethod() {
        return this.method;
    }

    @Override
    public List<Object> getArguments() {
        return this.arguments;
    }

    @Override
    public Object callRealMethod() {
        return this.realMethodInvoker.respond(this);
    }

    @Override
    public Object callRealMethodWithArgs(final Object ... arguments) {
        return this.realMethodInvoker.respond(new DelegatingMockInvocation(this){

            @Override
            public List<Object> getArguments() {
                return Arrays.asList(arguments);
            }
        });
    }

    public String toString() {
        String mockName = this.mockObject.getName();
        if (mockName == null) {
            mockName = String.format("<%s>", this.mockObject.getType().getSimpleName());
        }
        return String.format("%s.%s(%s)", mockName, this.method.getName(), this.render(this.arguments));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IMockInvocation)) {
            return false;
        }
        IMockInvocation otherInv = (IMockInvocation)other;
        return this.mockObject.getInstance() == otherInv.getMockObject().getInstance() && this.method.getName().equals(otherInv.getMethod().getName()) && ((Object)this.arguments).equals(otherInv.getArguments());
    }

    public int hashCode() {
        int result = this.mockObject.getInstance().hashCode();
        result = result * 31 + this.method.getName().hashCode();
        result = result * 31 + ((Object)this.arguments).hashCode();
        return result;
    }

    private String render(List<Object> arguments) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object arg : arguments) {
            strings.add(DefaultGroovyMethods.inspect((Object)arg));
        }
        return TextUtil.join(", ", strings);
    }
}

